<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFH ServiceType
 * @subpackage Services
 */
class XPRFH extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_Hierarchie
     * Meta information extracted from the WSDL
     * - documentation: Liste les supérieurs hiérarchique
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_Hierarchie_Param $params
     * @return string|bool
     */
    public function XPRF_Hierarchie(\StructType\XPRF_Hierarchie_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_Hierarchie($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
