<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFE ServiceType
 * @subpackage Services
 */
class XPRFE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_EnvoiConf
     * Meta information extracted from the WSDL
     * - documentation: Injection d'absence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_EnvoiConf_Param $params
     * @return \StructType\InfoUser|bool
     */
    public function XPRF_EnvoiConf(\StructType\XPRF_EnvoiConf_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_EnvoiConf($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InfoUser
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
