<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFA ServiceType
 * @subpackage Services
 */
class XPRFA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_AvancementDepot
     * Meta information extracted from the WSDL
     * - documentation: Permet de demander à Xparaph de compléter les acteurs d'étapes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_AvancementDepot_Param $params
     * @return string|bool
     */
    public function XPRF_AvancementDepot(\StructType\XPRF_AvancementDepot_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_AvancementDepot($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
