<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KryteriumTyp StructType
 * Meta information extracted from the WSDL
 * - type: oferta:KryteriumTyp
 * @subpackage Structs
 */
class KryteriumTyp extends AbstractStructBase
{
    /**
     * The Wojewodztwo
     * Meta information extracted from the WSDL
     * - choice: Wojewodztwo | Jednostka | Wszystkie
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $Wojewodztwo;
    /**
     * The Jednostka
     * Meta information extracted from the WSDL
     * - choice: Wojewodztwo | Jednostka | Wszystkie
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $Jednostka;
    /**
     * The Wszystkie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: Wojewodztwo | Jednostka | Wszystkie
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: ((T|t)(R|r)(U|u)(E|e))
     * @var string
     */
    public $Wszystkie;
    /**
     * Constructor method for KryteriumTyp
     * @uses KryteriumTyp::setWojewodztwo()
     * @uses KryteriumTyp::setJednostka()
     * @uses KryteriumTyp::setWszystkie()
     * @param string $wojewodztwo
     * @param string $jednostka
     * @param string $wszystkie
     */
    public function __construct($wojewodztwo = null, $jednostka = null, $wszystkie = null)
    {
        $this
            ->setWojewodztwo($wojewodztwo)
            ->setJednostka($jednostka)
            ->setWszystkie($wszystkie);
    }
    /**
     * Get Wojewodztwo value
     * @return string|null
     */
    public function getWojewodztwo()
    {
        return isset($this->Wojewodztwo) ? $this->Wojewodztwo : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWojewodztwo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWojewodztwo method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWojewodztwoForChoiceConstraintsFromSetWojewodztwo($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Jednostka',
            'Wszystkie',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Wojewodztwo can\'t be set as the property %s is already set. Only one property must be set among these properties: Wojewodztwo, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Wojewodztwo value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @uses \EnumType\WojewodztwoEnum::valueIsValid()
     * @uses \EnumType\WojewodztwoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wojewodztwo
     * @return \StructType\KryteriumTyp
     */
    public function setWojewodztwo($wojewodztwo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WojewodztwoEnum::valueIsValid($wojewodztwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WojewodztwoEnum', is_array($wojewodztwo) ? implode(', ', $wojewodztwo) : var_export($wojewodztwo, true), implode(', ', \EnumType\WojewodztwoEnum::getValidValues())), __LINE__);
        }
        // validation for constraint: choice(Wojewodztwo, Jednostka, Wszystkie)
        if ('' !== ($wojewodztwoChoiceErrorMessage = self::validateWojewodztwoForChoiceConstraintsFromSetWojewodztwo($wojewodztwo))) {
            throw new \InvalidArgumentException($wojewodztwoChoiceErrorMessage, __LINE__);
        }
        if (is_null($wojewodztwo) || (is_array($wojewodztwo) && empty($wojewodztwo))) {
            unset($this->Wojewodztwo);
        } else {
            $this->Wojewodztwo = $wojewodztwo;
        }
        return $this;
    }
    /**
     * Get Jednostka value
     * @return string|null
     */
    public function getJednostka()
    {
        return isset($this->Jednostka) ? $this->Jednostka : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJednostka method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJednostka method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJednostkaForChoiceConstraintsFromSetJednostka($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Wojewodztwo',
            'Wszystkie',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Jednostka can\'t be set as the property %s is already set. Only one property must be set among these properties: Jednostka, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Jednostka value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $jednostka
     * @return \StructType\KryteriumTyp
     */
    public function setJednostka($jednostka = null)
    {
        // validation for constraint: string
        if (!is_null($jednostka) && !is_string($jednostka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jednostka, true), gettype($jednostka)), __LINE__);
        }
        // validation for constraint: choice(Wojewodztwo, Jednostka, Wszystkie)
        if ('' !== ($jednostkaChoiceErrorMessage = self::validateJednostkaForChoiceConstraintsFromSetJednostka($jednostka))) {
            throw new \InvalidArgumentException($jednostkaChoiceErrorMessage, __LINE__);
        }
        if (is_null($jednostka) || (is_array($jednostka) && empty($jednostka))) {
            unset($this->Jednostka);
        } else {
            $this->Jednostka = $jednostka;
        }
        return $this;
    }
    /**
     * Get Wszystkie value
     * @return string|null
     */
    public function getWszystkie()
    {
        return isset($this->Wszystkie) ? $this->Wszystkie : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWszystkie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWszystkie method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWszystkieForChoiceConstraintsFromSetWszystkie($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Wojewodztwo',
            'Jednostka',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Wszystkie can\'t be set as the property %s is already set. Only one property must be set among these properties: Wszystkie, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Wszystkie value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $wszystkie
     * @return \StructType\KryteriumTyp
     */
    public function setWszystkie($wszystkie = null)
    {
        // validation for constraint: string
        if (!is_null($wszystkie) && !is_string($wszystkie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wszystkie, true), gettype($wszystkie)), __LINE__);
        }
        // validation for constraint: choice(Wojewodztwo, Jednostka, Wszystkie)
        if ('' !== ($wszystkieChoiceErrorMessage = self::validateWszystkieForChoiceConstraintsFromSetWszystkie($wszystkie))) {
            throw new \InvalidArgumentException($wszystkieChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(((T|t)(R|r)(U|u)(E|e)))
        if (!is_null($wszystkie) && !preg_match('/((T|t)(R|r)(U|u)(E|e))/', $wszystkie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ((T|t)(R|r)(U|u)(E|e))', var_export($wszystkie, true)), __LINE__);
        }
        if (is_null($wszystkie) || (is_array($wszystkie) && empty($wszystkie))) {
            unset($this->Wszystkie);
        } else {
            $this->Wszystkie = $wszystkie;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KryteriumTyp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
