<?php

namespace EnumType;

/**
 * This class stands for WojewodztwoEnum EnumType
 * @subpackage Enumerations
 */
class WojewodztwoEnum
{
    /**
     * Constant for value '2'
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '4'
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '6'
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Constant for value '8'
     * @return string '8'
     */
    const VALUE_8 = '8';
    /**
     * Constant for value '10'
     * @return string '10'
     */
    const VALUE_10 = '10';
    /**
     * Constant for value '12'
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '14'
     * @return string '14'
     */
    const VALUE_14 = '14';
    /**
     * Constant for value '16'
     * @return string '16'
     */
    const VALUE_16 = '16';
    /**
     * Constant for value '18'
     * @return string '18'
     */
    const VALUE_18 = '18';
    /**
     * Constant for value '20'
     * @return string '20'
     */
    const VALUE_20 = '20';
    /**
     * Constant for value '22'
     * @return string '22'
     */
    const VALUE_22 = '22';
    /**
     * Constant for value '24'
     * @return string '24'
     */
    const VALUE_24 = '24';
    /**
     * Constant for value '26'
     * @return string '26'
     */
    const VALUE_26 = '26';
    /**
     * Constant for value '28'
     * @return string '28'
     */
    const VALUE_28 = '28';
    /**
     * Constant for value '30'
     * @return string '30'
     */
    const VALUE_30 = '30';
    /**
     * Constant for value '32'
     * @return string '32'
     */
    const VALUE_32 = '32';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_2
     * @uses self::VALUE_4
     * @uses self::VALUE_6
     * @uses self::VALUE_8
     * @uses self::VALUE_10
     * @uses self::VALUE_12
     * @uses self::VALUE_14
     * @uses self::VALUE_16
     * @uses self::VALUE_18
     * @uses self::VALUE_20
     * @uses self::VALUE_22
     * @uses self::VALUE_24
     * @uses self::VALUE_26
     * @uses self::VALUE_28
     * @uses self::VALUE_30
     * @uses self::VALUE_32
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_2,
            self::VALUE_4,
            self::VALUE_6,
            self::VALUE_8,
            self::VALUE_10,
            self::VALUE_12,
            self::VALUE_14,
            self::VALUE_16,
            self::VALUE_18,
            self::VALUE_20,
            self::VALUE_22,
            self::VALUE_24,
            self::VALUE_26,
            self::VALUE_28,
            self::VALUE_30,
            self::VALUE_32,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
