<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pytDane StructType
 * Meta information extracted from the WSDL
 * - type: tns:pytDane
 * @subpackage Structs
 */
class PytDane extends AbstractStructBase
{
    /**
     * The Partner
     * @var string
     */
    public $Partner;
    /**
     * The Kryterium
     * @var \StructType\KryteriumTyp
     */
    public $Kryterium;
    /**
     * Constructor method for pytDane
     * @uses PytDane::setPartner()
     * @uses PytDane::setKryterium()
     * @param string $partner
     * @param \StructType\KryteriumTyp $kryterium
     */
    public function __construct($partner = null, \StructType\KryteriumTyp $kryterium = null)
    {
        $this
            ->setPartner($partner)
            ->setKryterium($kryterium);
    }
    /**
     * Get Partner value
     * @return string|null
     */
    public function getPartner()
    {
        return $this->Partner;
    }
    /**
     * Set Partner value
     * @param string $partner
     * @return \StructType\PytDane
     */
    public function setPartner($partner = null)
    {
        // validation for constraint: string
        if (!is_null($partner) && !is_string($partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner, true), gettype($partner)), __LINE__);
        }
        $this->Partner = $partner;
        return $this;
    }
    /**
     * Get Kryterium value
     * @return \StructType\KryteriumTyp|null
     */
    public function getKryterium()
    {
        return $this->Kryterium;
    }
    /**
     * Set Kryterium value
     * @param \StructType\KryteriumTyp $kryterium
     * @return \StructType\PytDane
     */
    public function setKryterium(\StructType\KryteriumTyp $kryterium = null)
    {
        $this->Kryterium = $kryterium;
        return $this;
    }
}
