<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dane ServiceType
 * @subpackage Services
 */
class Dane extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Dane
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Dane $parameters
     * @return \StructType\DaneResponse|bool
     */
    public function Dane(\StructType\Dane $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Dane($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DaneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
