<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StartTransactionResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the StartTransaction.conf PDU
 * @subpackage Structs
 */
class StartTransactionResponse extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $transactionId;
    /**
     * The idTagInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\IdTagInfo
     */
    public $idTagInfo;
    /**
     * Constructor method for StartTransactionResponse
     * @uses StartTransactionResponse::setTransactionId()
     * @uses StartTransactionResponse::setIdTagInfo()
     * @param int $transactionId
     * @param \StructType\IdTagInfo $idTagInfo
     */
    public function __construct($transactionId = null, \StructType\IdTagInfo $idTagInfo = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setIdTagInfo($idTagInfo);
    }
    /**
     * Get transactionId value
     * @return int
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\StartTransactionResponse
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get idTagInfo value
     * @return \StructType\IdTagInfo
     */
    public function getIdTagInfo()
    {
        return $this->idTagInfo;
    }
    /**
     * Set idTagInfo value
     * @param \StructType\IdTagInfo $idTagInfo
     * @return \StructType\StartTransactionResponse
     */
    public function setIdTagInfo(\StructType\IdTagInfo $idTagInfo = null)
    {
        $this->idTagInfo = $idTagInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StartTransactionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
