<?php

namespace EnumType;

/**
 * This class stands for ValueFormat EnumType
 * @subpackage Enumerations
 */
class ValueFormat
{
    /**
     * Constant for value 'Raw'
     * @return string 'Raw'
     */
    const VALUE_RAW = 'Raw';
    /**
     * Constant for value 'SignedData'
     * @return string 'SignedData'
     */
    const VALUE_SIGNED_DATA = 'SignedData';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RAW
     * @uses self::VALUE_SIGNED_DATA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RAW,
            self::VALUE_SIGNED_DATA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
