<?php

namespace EnumType;

/**
 * This class stands for DiagnosticsStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the diagnostics-status-value
 * @subpackage Enumerations
 */
class DiagnosticsStatus
{
    /**
     * Constant for value 'Uploaded'
     * @return string 'Uploaded'
     */
    const VALUE_UPLOADED = 'Uploaded';
    /**
     * Constant for value 'UploadFailed'
     * @return string 'UploadFailed'
     */
    const VALUE_UPLOAD_FAILED = 'UploadFailed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPLOADED
     * @uses self::VALUE_UPLOAD_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPLOADED,
            self::VALUE_UPLOAD_FAILED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
