<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopTransactionRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the StopTransaction.req PDU
 * @subpackage Structs
 */
class StopTransactionRequest extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $transactionId;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $timestamp;
    /**
     * The meterStop
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $meterStop;
    /**
     * The idTag
     * Meta information extracted from the WSDL
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idTag;
    /**
     * The transactionData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TransactionData[]
     */
    public $transactionData;
    /**
     * Constructor method for StopTransactionRequest
     * @uses StopTransactionRequest::setTransactionId()
     * @uses StopTransactionRequest::setTimestamp()
     * @uses StopTransactionRequest::setMeterStop()
     * @uses StopTransactionRequest::setIdTag()
     * @uses StopTransactionRequest::setTransactionData()
     * @param int $transactionId
     * @param string $timestamp
     * @param int $meterStop
     * @param string $idTag
     * @param \StructType\TransactionData[] $transactionData
     */
    public function __construct($transactionId = null, $timestamp = null, $meterStop = null, $idTag = null, array $transactionData = array())
    {
        $this
            ->setTransactionId($transactionId)
            ->setTimestamp($timestamp)
            ->setMeterStop($meterStop)
            ->setIdTag($idTag)
            ->setTransactionData($transactionData);
    }
    /**
     * Get transactionId value
     * @return int
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\StopTransactionRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\StopTransactionRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get meterStop value
     * @return int
     */
    public function getMeterStop()
    {
        return $this->meterStop;
    }
    /**
     * Set meterStop value
     * @param int $meterStop
     * @return \StructType\StopTransactionRequest
     */
    public function setMeterStop($meterStop = null)
    {
        // validation for constraint: int
        if (!is_null($meterStop) && !(is_int($meterStop) || ctype_digit($meterStop))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meterStop, true), gettype($meterStop)), __LINE__);
        }
        $this->meterStop = $meterStop;
        return $this;
    }
    /**
     * Get idTag value
     * @return string|null
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\StopTransactionRequest
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTag, true), gettype($idTag)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($idTag) && mb_strlen($idTag) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Get transactionData value
     * @return \StructType\TransactionData[]|null
     */
    public function getTransactionData()
    {
        return $this->transactionData;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionDataForArrayConstraintsFromSetTransactionData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stopTransactionRequestTransactionDataItem) {
            // validation for constraint: itemType
            if (!$stopTransactionRequestTransactionDataItem instanceof \StructType\TransactionData) {
                $invalidValues[] = is_object($stopTransactionRequestTransactionDataItem) ? get_class($stopTransactionRequestTransactionDataItem) : sprintf('%s(%s)', gettype($stopTransactionRequestTransactionDataItem), var_export($stopTransactionRequestTransactionDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The transactionData property can only contain items of type \StructType\TransactionData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set transactionData value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionData[] $transactionData
     * @return \StructType\StopTransactionRequest
     */
    public function setTransactionData(array $transactionData = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionDataArrayErrorMessage = self::validateTransactionDataForArrayConstraintsFromSetTransactionData($transactionData))) {
            throw new \InvalidArgumentException($transactionDataArrayErrorMessage, __LINE__);
        }
        $this->transactionData = $transactionData;
        return $this;
    }
    /**
     * Add item to transactionData value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionData $item
     * @return \StructType\StopTransactionRequest
     */
    public function addToTransactionData(\StructType\TransactionData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionData) {
            throw new \InvalidArgumentException(sprintf('The transactionData property can only contain items of type \StructType\TransactionData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->transactionData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
