<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusNotificationRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the StatusNotification.req PDU
 * @subpackage Structs
 */
class StatusNotificationRequest extends AbstractStructBase
{
    /**
     * The connectorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $connectorId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The info
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $info;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * The vendorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorId;
    /**
     * The vendorErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorErrorCode;
    /**
     * Constructor method for StatusNotificationRequest
     * @uses StatusNotificationRequest::setConnectorId()
     * @uses StatusNotificationRequest::setStatus()
     * @uses StatusNotificationRequest::setErrorCode()
     * @uses StatusNotificationRequest::setInfo()
     * @uses StatusNotificationRequest::setTimestamp()
     * @uses StatusNotificationRequest::setVendorId()
     * @uses StatusNotificationRequest::setVendorErrorCode()
     * @param int $connectorId
     * @param string $status
     * @param string $errorCode
     * @param string $info
     * @param string $timestamp
     * @param string $vendorId
     * @param string $vendorErrorCode
     */
    public function __construct($connectorId = null, $status = null, $errorCode = null, $info = null, $timestamp = null, $vendorId = null, $vendorErrorCode = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setStatus($status)
            ->setErrorCode($errorCode)
            ->setInfo($info)
            ->setTimestamp($timestamp)
            ->setVendorId($vendorId)
            ->setVendorErrorCode($vendorErrorCode);
    }
    /**
     * Get connectorId value
     * @return int
     */
    public function getConnectorId()
    {
        return $this->connectorId;
    }
    /**
     * Set connectorId value
     * @param int $connectorId
     * @return \StructType\StatusNotificationRequest
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: int
        if (!is_null($connectorId) && !(is_int($connectorId) || ctype_digit($connectorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectorId, true), gettype($connectorId)), __LINE__);
        }
        $this->connectorId = $connectorId;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ChargePointStatus::valueIsValid()
     * @uses \EnumType\ChargePointStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\StatusNotificationRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargePointStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ChargePointStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ChargePointStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\ChargePointErrorCode::valueIsValid()
     * @uses \EnumType\ChargePointErrorCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\StatusNotificationRequest
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargePointErrorCode::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ChargePointErrorCode', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\ChargePointErrorCode::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \StructType\StatusNotificationRequest
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\StatusNotificationRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get vendorId value
     * @return string|null
     */
    public function getVendorId()
    {
        return $this->vendorId;
    }
    /**
     * Set vendorId value
     * @param string $vendorId
     * @return \StructType\StatusNotificationRequest
     */
    public function setVendorId($vendorId = null)
    {
        // validation for constraint: string
        if (!is_null($vendorId) && !is_string($vendorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorId, true), gettype($vendorId)), __LINE__);
        }
        $this->vendorId = $vendorId;
        return $this;
    }
    /**
     * Get vendorErrorCode value
     * @return string|null
     */
    public function getVendorErrorCode()
    {
        return $this->vendorErrorCode;
    }
    /**
     * Set vendorErrorCode value
     * @param string $vendorErrorCode
     * @return \StructType\StatusNotificationRequest
     */
    public function setVendorErrorCode($vendorErrorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorErrorCode) && !is_string($vendorErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorErrorCode, true), gettype($vendorErrorCode)), __LINE__);
        }
        $this->vendorErrorCode = $vendorErrorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusNotificationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
