<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterValuesRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the MeterValues.req PDU
 * @subpackage Structs
 */
class MeterValuesRequest extends AbstractStructBase
{
    /**
     * The connectorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $connectorId;
    /**
     * The transactionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $transactionId;
    /**
     * The values
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MeterValue[]
     */
    public $values;
    /**
     * Constructor method for MeterValuesRequest
     * @uses MeterValuesRequest::setConnectorId()
     * @uses MeterValuesRequest::setTransactionId()
     * @uses MeterValuesRequest::setValues()
     * @param int $connectorId
     * @param int $transactionId
     * @param \StructType\MeterValue[] $values
     */
    public function __construct($connectorId = null, $transactionId = null, array $values = array())
    {
        $this
            ->setConnectorId($connectorId)
            ->setTransactionId($transactionId)
            ->setValues($values);
    }
    /**
     * Get connectorId value
     * @return int
     */
    public function getConnectorId()
    {
        return $this->connectorId;
    }
    /**
     * Set connectorId value
     * @param int $connectorId
     * @return \StructType\MeterValuesRequest
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: int
        if (!is_null($connectorId) && !(is_int($connectorId) || ctype_digit($connectorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectorId, true), gettype($connectorId)), __LINE__);
        }
        $this->connectorId = $connectorId;
        return $this;
    }
    /**
     * Get transactionId value
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\MeterValuesRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get values value
     * @return \StructType\MeterValue[]|null
     */
    public function getValues()
    {
        return $this->values;
    }
    /**
     * This method is responsible for validating the values passed to the setValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValuesForArrayConstraintsFromSetValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meterValuesRequestValuesItem) {
            // validation for constraint: itemType
            if (!$meterValuesRequestValuesItem instanceof \StructType\MeterValue) {
                $invalidValues[] = is_object($meterValuesRequestValuesItem) ? get_class($meterValuesRequestValuesItem) : sprintf('%s(%s)', gettype($meterValuesRequestValuesItem), var_export($meterValuesRequestValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The values property can only contain items of type \StructType\MeterValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set values value
     * @throws \InvalidArgumentException
     * @param \StructType\MeterValue[] $values
     * @return \StructType\MeterValuesRequest
     */
    public function setValues(array $values = array())
    {
        // validation for constraint: array
        if ('' !== ($valuesArrayErrorMessage = self::validateValuesForArrayConstraintsFromSetValues($values))) {
            throw new \InvalidArgumentException($valuesArrayErrorMessage, __LINE__);
        }
        $this->values = $values;
        return $this;
    }
    /**
     * Add item to values value
     * @throws \InvalidArgumentException
     * @param \StructType\MeterValue $item
     * @return \StructType\MeterValuesRequest
     */
    public function addToValues(\StructType\MeterValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeterValue) {
            throw new \InvalidArgumentException(sprintf('The values property can only contain items of type \StructType\MeterValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->values[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeterValuesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
