<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeartbeatResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the Heartbeat.conf PDU
 * @subpackage Structs
 */
class HeartbeatResponse extends AbstractStructBase
{
    /**
     * The currentTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currentTime;
    /**
     * Constructor method for HeartbeatResponse
     * @uses HeartbeatResponse::setCurrentTime()
     * @param string $currentTime
     */
    public function __construct($currentTime = null)
    {
        $this
            ->setCurrentTime($currentTime);
    }
    /**
     * Get currentTime value
     * @return string
     */
    public function getCurrentTime()
    {
        return $this->currentTime;
    }
    /**
     * Set currentTime value
     * @param string $currentTime
     * @return \StructType\HeartbeatResponse
     */
    public function setCurrentTime($currentTime = null)
    {
        // validation for constraint: string
        if (!is_null($currentTime) && !is_string($currentTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentTime, true), gettype($currentTime)), __LINE__);
        }
        $this->currentTime = $currentTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HeartbeatResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
