<?php

namespace EnumType;

/**
 * This class stands for UnitOfMeasure EnumType
 * @subpackage Enumerations
 */
class UnitOfMeasure
{
    /**
     * Constant for value 'Wh'
     * @return string 'Wh'
     */
    const VALUE_WH = 'Wh';
    /**
     * Constant for value 'kWh'
     * @return string 'kWh'
     */
    const VALUE_K_WH = 'kWh';
    /**
     * Constant for value 'varh'
     * @return string 'varh'
     */
    const VALUE_VARH = 'varh';
    /**
     * Constant for value 'kvarh'
     * @return string 'kvarh'
     */
    const VALUE_KVARH = 'kvarh';
    /**
     * Constant for value 'W'
     * @return string 'W'
     */
    const VALUE_W = 'W';
    /**
     * Constant for value 'kW'
     * @return string 'kW'
     */
    const VALUE_K_W = 'kW';
    /**
     * Constant for value 'var'
     * @return string 'var'
     */
    const VALUE_VAR = 'var';
    /**
     * Constant for value 'kvar'
     * @return string 'kvar'
     */
    const VALUE_KVAR = 'kvar';
    /**
     * Constant for value 'Amp'
     * @return string 'Amp'
     */
    const VALUE_AMP = 'Amp';
    /**
     * Constant for value 'Volt'
     * @return string 'Volt'
     */
    const VALUE_VOLT = 'Volt';
    /**
     * Constant for value 'Celsius'
     * @return string 'Celsius'
     */
    const VALUE_CELSIUS = 'Celsius';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WH
     * @uses self::VALUE_K_WH
     * @uses self::VALUE_VARH
     * @uses self::VALUE_KVARH
     * @uses self::VALUE_W
     * @uses self::VALUE_K_W
     * @uses self::VALUE_VAR
     * @uses self::VALUE_KVAR
     * @uses self::VALUE_AMP
     * @uses self::VALUE_VOLT
     * @uses self::VALUE_CELSIUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WH,
            self::VALUE_K_WH,
            self::VALUE_VARH,
            self::VALUE_KVARH,
            self::VALUE_W,
            self::VALUE_K_W,
            self::VALUE_VAR,
            self::VALUE_KVAR,
            self::VALUE_AMP,
            self::VALUE_VOLT,
            self::VALUE_CELSIUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
