<?php

namespace EnumType;

/**
 * This class stands for Measurand EnumType
 * @subpackage Enumerations
 */
class Measurand
{
    /**
     * Constant for value 'Energy.Active.Export.Register'
     * @return string 'Energy.Active.Export.Register'
     */
    const VALUE_ENERGY_ACTIVE_EXPORT_REGISTER = 'Energy.Active.Export.Register';
    /**
     * Constant for value 'Energy.Active.Import.Register'
     * @return string 'Energy.Active.Import.Register'
     */
    const VALUE_ENERGY_ACTIVE_IMPORT_REGISTER = 'Energy.Active.Import.Register';
    /**
     * Constant for value 'Energy.Reactive.Export.Register'
     * @return string 'Energy.Reactive.Export.Register'
     */
    const VALUE_ENERGY_REACTIVE_EXPORT_REGISTER = 'Energy.Reactive.Export.Register';
    /**
     * Constant for value 'Energy.Reactive.Import.Register'
     * @return string 'Energy.Reactive.Import.Register'
     */
    const VALUE_ENERGY_REACTIVE_IMPORT_REGISTER = 'Energy.Reactive.Import.Register';
    /**
     * Constant for value 'Energy.Active.Export.Interval'
     * @return string 'Energy.Active.Export.Interval'
     */
    const VALUE_ENERGY_ACTIVE_EXPORT_INTERVAL = 'Energy.Active.Export.Interval';
    /**
     * Constant for value 'Energy.Active.Import.Interval'
     * @return string 'Energy.Active.Import.Interval'
     */
    const VALUE_ENERGY_ACTIVE_IMPORT_INTERVAL = 'Energy.Active.Import.Interval';
    /**
     * Constant for value 'Energy.Reactive.Export.Interval'
     * @return string 'Energy.Reactive.Export.Interval'
     */
    const VALUE_ENERGY_REACTIVE_EXPORT_INTERVAL = 'Energy.Reactive.Export.Interval';
    /**
     * Constant for value 'Energy.Reactive.Import.Interval'
     * @return string 'Energy.Reactive.Import.Interval'
     */
    const VALUE_ENERGY_REACTIVE_IMPORT_INTERVAL = 'Energy.Reactive.Import.Interval';
    /**
     * Constant for value 'Power.Active.Export'
     * @return string 'Power.Active.Export'
     */
    const VALUE_POWER_ACTIVE_EXPORT = 'Power.Active.Export';
    /**
     * Constant for value 'Power.Active.Import'
     * @return string 'Power.Active.Import'
     */
    const VALUE_POWER_ACTIVE_IMPORT = 'Power.Active.Import';
    /**
     * Constant for value 'Power.Reactive.Export'
     * @return string 'Power.Reactive.Export'
     */
    const VALUE_POWER_REACTIVE_EXPORT = 'Power.Reactive.Export';
    /**
     * Constant for value 'Power.Reactive.Import'
     * @return string 'Power.Reactive.Import'
     */
    const VALUE_POWER_REACTIVE_IMPORT = 'Power.Reactive.Import';
    /**
     * Constant for value 'Current.Export'
     * @return string 'Current.Export'
     */
    const VALUE_CURRENT_EXPORT = 'Current.Export';
    /**
     * Constant for value 'Current.Import'
     * @return string 'Current.Import'
     */
    const VALUE_CURRENT_IMPORT = 'Current.Import';
    /**
     * Constant for value 'Voltage'
     * @return string 'Voltage'
     */
    const VALUE_VOLTAGE = 'Voltage';
    /**
     * Constant for value 'Temperature'
     * @return string 'Temperature'
     */
    const VALUE_TEMPERATURE = 'Temperature';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENERGY_ACTIVE_EXPORT_REGISTER
     * @uses self::VALUE_ENERGY_ACTIVE_IMPORT_REGISTER
     * @uses self::VALUE_ENERGY_REACTIVE_EXPORT_REGISTER
     * @uses self::VALUE_ENERGY_REACTIVE_IMPORT_REGISTER
     * @uses self::VALUE_ENERGY_ACTIVE_EXPORT_INTERVAL
     * @uses self::VALUE_ENERGY_ACTIVE_IMPORT_INTERVAL
     * @uses self::VALUE_ENERGY_REACTIVE_EXPORT_INTERVAL
     * @uses self::VALUE_ENERGY_REACTIVE_IMPORT_INTERVAL
     * @uses self::VALUE_POWER_ACTIVE_EXPORT
     * @uses self::VALUE_POWER_ACTIVE_IMPORT
     * @uses self::VALUE_POWER_REACTIVE_EXPORT
     * @uses self::VALUE_POWER_REACTIVE_IMPORT
     * @uses self::VALUE_CURRENT_EXPORT
     * @uses self::VALUE_CURRENT_IMPORT
     * @uses self::VALUE_VOLTAGE
     * @uses self::VALUE_TEMPERATURE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENERGY_ACTIVE_EXPORT_REGISTER,
            self::VALUE_ENERGY_ACTIVE_IMPORT_REGISTER,
            self::VALUE_ENERGY_REACTIVE_EXPORT_REGISTER,
            self::VALUE_ENERGY_REACTIVE_IMPORT_REGISTER,
            self::VALUE_ENERGY_ACTIVE_EXPORT_INTERVAL,
            self::VALUE_ENERGY_ACTIVE_IMPORT_INTERVAL,
            self::VALUE_ENERGY_REACTIVE_EXPORT_INTERVAL,
            self::VALUE_ENERGY_REACTIVE_IMPORT_INTERVAL,
            self::VALUE_POWER_ACTIVE_EXPORT,
            self::VALUE_POWER_ACTIVE_IMPORT,
            self::VALUE_POWER_REACTIVE_EXPORT,
            self::VALUE_POWER_REACTIVE_IMPORT,
            self::VALUE_CURRENT_EXPORT,
            self::VALUE_CURRENT_IMPORT,
            self::VALUE_VOLTAGE,
            self::VALUE_TEMPERATURE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
