<?php

namespace EnumType;

/**
 * This class stands for ChargePointStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the charge-point-status-value
 * @subpackage Enumerations
 */
class ChargePointStatus
{
    /**
     * Constant for value 'Available'
     * @return string 'Available'
     */
    const VALUE_AVAILABLE = 'Available';
    /**
     * Constant for value 'Occupied'
     * @return string 'Occupied'
     */
    const VALUE_OCCUPIED = 'Occupied';
    /**
     * Constant for value 'Faulted'
     * @return string 'Faulted'
     */
    const VALUE_FAULTED = 'Faulted';
    /**
     * Constant for value 'Unavailable'
     * @return string 'Unavailable'
     */
    const VALUE_UNAVAILABLE = 'Unavailable';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_OCCUPIED
     * @uses self::VALUE_FAULTED
     * @uses self::VALUE_UNAVAILABLE
     * @uses self::VALUE_RESERVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE,
            self::VALUE_OCCUPIED,
            self::VALUE_FAULTED,
            self::VALUE_UNAVAILABLE,
            self::VALUE_RESERVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
