<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterValue StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines single value of the meter-value-value
 * @subpackage Structs
 */
class MeterValue extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Value[]
     */
    public $value;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * Constructor method for MeterValue
     * @uses MeterValue::setValue()
     * @uses MeterValue::setTimestamp()
     * @param \StructType\Value[] $value
     * @param string $timestamp
     */
    public function __construct(array $value = array(), $timestamp = null)
    {
        $this
            ->setValue($value)
            ->setTimestamp($timestamp);
    }
    /**
     * Get value value
     * @return \StructType\Value[]
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meterValueValueItem) {
            // validation for constraint: itemType
            if (!$meterValueValueItem instanceof \StructType\Value) {
                $invalidValues[] = is_object($meterValueValueItem) ? get_class($meterValueValueItem) : sprintf('%s(%s)', gettype($meterValueValueItem), var_export($meterValueValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The value property can only contain items of type \StructType\Value, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \StructType\Value[] $value
     * @return \StructType\MeterValue
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \StructType\Value $item
     * @return \StructType\MeterValue
     */
    public function addToValue(\StructType\Value $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Value) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of type \StructType\Value, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\MeterValue
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeterValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
