<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdTagInfo StructType
 * @subpackage Structs
 */
class IdTagInfo extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The expiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expiryDate;
    /**
     * The parentIdTag
     * Meta information extracted from the WSDL
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parentIdTag;
    /**
     * Constructor method for IdTagInfo
     * @uses IdTagInfo::setStatus()
     * @uses IdTagInfo::setExpiryDate()
     * @uses IdTagInfo::setParentIdTag()
     * @param string $status
     * @param string $expiryDate
     * @param string $parentIdTag
     */
    public function __construct($status = null, $expiryDate = null, $parentIdTag = null)
    {
        $this
            ->setStatus($status)
            ->setExpiryDate($expiryDate)
            ->setParentIdTag($parentIdTag);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AuthorizationStatus::valueIsValid()
     * @uses \EnumType\AuthorizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\IdTagInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AuthorizationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AuthorizationStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AuthorizationStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \StructType\IdTagInfo
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get parentIdTag value
     * @return string|null
     */
    public function getParentIdTag()
    {
        return $this->parentIdTag;
    }
    /**
     * Set parentIdTag value
     * @param string $parentIdTag
     * @return \StructType\IdTagInfo
     */
    public function setParentIdTag($parentIdTag = null)
    {
        // validation for constraint: string
        if (!is_null($parentIdTag) && !is_string($parentIdTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentIdTag, true), gettype($parentIdTag)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($parentIdTag) && mb_strlen($parentIdTag) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($parentIdTag)), __LINE__);
        }
        $this->parentIdTag = $parentIdTag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdTagInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
