<?php

namespace EnumType;

/**
 * This class stands for FirmwareStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the firmware-status-value
 * @subpackage Enumerations
 */
class FirmwareStatus
{
    /**
     * Constant for value 'Downloaded'
     * @return string 'Downloaded'
     */
    const VALUE_DOWNLOADED = 'Downloaded';
    /**
     * Constant for value 'DownloadFailed'
     * @return string 'DownloadFailed'
     */
    const VALUE_DOWNLOAD_FAILED = 'DownloadFailed';
    /**
     * Constant for value 'InstallationFailed'
     * @return string 'InstallationFailed'
     */
    const VALUE_INSTALLATION_FAILED = 'InstallationFailed';
    /**
     * Constant for value 'Installed'
     * @return string 'Installed'
     */
    const VALUE_INSTALLED = 'Installed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DOWNLOADED
     * @uses self::VALUE_DOWNLOAD_FAILED
     * @uses self::VALUE_INSTALLATION_FAILED
     * @uses self::VALUE_INSTALLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOWNLOADED,
            self::VALUE_DOWNLOAD_FAILED,
            self::VALUE_INSTALLATION_FAILED,
            self::VALUE_INSTALLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
