<?php

namespace EnumType;

/**
 * This class stands for ChargePointErrorCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the charge-point-error-value
 * @subpackage Enumerations
 */
class ChargePointErrorCode
{
    /**
     * Constant for value 'ConnectorLockFailure'
     * @return string 'ConnectorLockFailure'
     */
    const VALUE_CONNECTOR_LOCK_FAILURE = 'ConnectorLockFailure';
    /**
     * Constant for value 'HighTemperature'
     * @return string 'HighTemperature'
     */
    const VALUE_HIGH_TEMPERATURE = 'HighTemperature';
    /**
     * Constant for value 'Mode3Error'
     * @return string 'Mode3Error'
     */
    const VALUE_MODE_3_ERROR = 'Mode3Error';
    /**
     * Constant for value 'NoError'
     * @return string 'NoError'
     */
    const VALUE_NO_ERROR = 'NoError';
    /**
     * Constant for value 'PowerMeterFailure'
     * @return string 'PowerMeterFailure'
     */
    const VALUE_POWER_METER_FAILURE = 'PowerMeterFailure';
    /**
     * Constant for value 'PowerSwitchFailure'
     * @return string 'PowerSwitchFailure'
     */
    const VALUE_POWER_SWITCH_FAILURE = 'PowerSwitchFailure';
    /**
     * Constant for value 'ReaderFailure'
     * @return string 'ReaderFailure'
     */
    const VALUE_READER_FAILURE = 'ReaderFailure';
    /**
     * Constant for value 'ResetFailure'
     * @return string 'ResetFailure'
     */
    const VALUE_RESET_FAILURE = 'ResetFailure';
    /**
     * Constant for value 'GroundFailure'
     * @return string 'GroundFailure'
     */
    const VALUE_GROUND_FAILURE = 'GroundFailure';
    /**
     * Constant for value 'OverCurrentFailure'
     * @return string 'OverCurrentFailure'
     */
    const VALUE_OVER_CURRENT_FAILURE = 'OverCurrentFailure';
    /**
     * Constant for value 'UnderVoltage'
     * @return string 'UnderVoltage'
     */
    const VALUE_UNDER_VOLTAGE = 'UnderVoltage';
    /**
     * Constant for value 'WeakSignal'
     * @return string 'WeakSignal'
     */
    const VALUE_WEAK_SIGNAL = 'WeakSignal';
    /**
     * Constant for value 'OtherError'
     * @return string 'OtherError'
     */
    const VALUE_OTHER_ERROR = 'OtherError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONNECTOR_LOCK_FAILURE
     * @uses self::VALUE_HIGH_TEMPERATURE
     * @uses self::VALUE_MODE_3_ERROR
     * @uses self::VALUE_NO_ERROR
     * @uses self::VALUE_POWER_METER_FAILURE
     * @uses self::VALUE_POWER_SWITCH_FAILURE
     * @uses self::VALUE_READER_FAILURE
     * @uses self::VALUE_RESET_FAILURE
     * @uses self::VALUE_GROUND_FAILURE
     * @uses self::VALUE_OVER_CURRENT_FAILURE
     * @uses self::VALUE_UNDER_VOLTAGE
     * @uses self::VALUE_WEAK_SIGNAL
     * @uses self::VALUE_OTHER_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONNECTOR_LOCK_FAILURE,
            self::VALUE_HIGH_TEMPERATURE,
            self::VALUE_MODE_3_ERROR,
            self::VALUE_NO_ERROR,
            self::VALUE_POWER_METER_FAILURE,
            self::VALUE_POWER_SWITCH_FAILURE,
            self::VALUE_READER_FAILURE,
            self::VALUE_RESET_FAILURE,
            self::VALUE_GROUND_FAILURE,
            self::VALUE_OVER_CURRENT_FAILURE,
            self::VALUE_UNDER_VOLTAGE,
            self::VALUE_WEAK_SIGNAL,
            self::VALUE_OTHER_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
