<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Unlock ServiceType
 */
$unlock = new \ServiceType\Unlock($options);
$unlock->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for UnlockConnector operation/method
 */
if ($unlock->UnlockConnector(new \StructType\UnlockConnectorRequest()) !== false) {
    print_r($unlock->getResult());
} else {
    print_r($unlock->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
$reset->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for Reset operation/method
 */
if ($reset->Reset(new \StructType\ResetRequest()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
$change->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for ChangeAvailability operation/method
 */
if ($change->ChangeAvailability(new \StructType\ChangeAvailabilityRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeConfiguration operation/method
 */
if ($change->ChangeConfiguration(new \StructType\ChangeConfigurationRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for GetDiagnostics operation/method
 */
if ($get->GetDiagnostics(new \StructType\GetDiagnosticsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConfiguration operation/method
 */
if ($get->GetConfiguration(new \StructType\GetConfigurationRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLocalListVersion operation/method
 */
if ($get->GetLocalListVersion(new \StructType\GetLocalListVersionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Clear ServiceType
 */
$clear = new \ServiceType\Clear($options);
$clear->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for ClearCache operation/method
 */
if ($clear->ClearCache(new \StructType\ClearCacheRequest()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for UpdateFirmware operation/method
 */
if ($update->UpdateFirmware(new \StructType\UpdateFirmwareRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Remote ServiceType
 */
$remote = new \ServiceType\Remote($options);
$remote->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for RemoteStartTransaction operation/method
 */
if ($remote->RemoteStartTransaction(new \StructType\RemoteStartTransactionRequest()) !== false) {
    print_r($remote->getResult());
} else {
    print_r($remote->getLastError());
}
/**
 * Sample call for RemoteStopTransaction operation/method
 */
if ($remote->RemoteStopTransaction(new \StructType\RemoteStopTransactionRequest()) !== false) {
    print_r($remote->getResult());
} else {
    print_r($remote->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
$cancel->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for CancelReservation operation/method
 */
if ($cancel->CancelReservation(new \StructType\CancelReservationRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Data ServiceType
 */
$data = new \ServiceType\Data($options);
$data->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for DataTransfer operation/method
 */
if ($data->DataTransfer(new \StructType\DataTransferRequest()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Samples for Reserve ServiceType
 */
$reserve = new \ServiceType\Reserve($options);
$reserve->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for ReserveNow operation/method
 */
if ($reserve->ReserveNow(new \StructType\ReserveNowRequest()) !== false) {
    print_r($reserve->getResult());
} else {
    print_r($reserve->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderChargeBoxIdentity($chargeBoxIdentity);
/**
 * Sample call for SendLocalList operation/method
 */
if ($send->SendLocalList(new \StructType\SendLocalListRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
