<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFirmwareRequest StructType
 * @subpackage Structs
 */
class UpdateFirmwareRequest extends AbstractStructBase
{
    /**
     * The retrieveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $retrieveDate;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $location;
    /**
     * The retries
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $retries;
    /**
     * The retryInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $retryInterval;
    /**
     * Constructor method for UpdateFirmwareRequest
     * @uses UpdateFirmwareRequest::setRetrieveDate()
     * @uses UpdateFirmwareRequest::setLocation()
     * @uses UpdateFirmwareRequest::setRetries()
     * @uses UpdateFirmwareRequest::setRetryInterval()
     * @param string $retrieveDate
     * @param string $location
     * @param int $retries
     * @param int $retryInterval
     */
    public function __construct($retrieveDate = null, $location = null, $retries = null, $retryInterval = null)
    {
        $this
            ->setRetrieveDate($retrieveDate)
            ->setLocation($location)
            ->setRetries($retries)
            ->setRetryInterval($retryInterval);
    }
    /**
     * Get retrieveDate value
     * @return string
     */
    public function getRetrieveDate()
    {
        return $this->retrieveDate;
    }
    /**
     * Set retrieveDate value
     * @param string $retrieveDate
     * @return \StructType\UpdateFirmwareRequest
     */
    public function setRetrieveDate($retrieveDate = null)
    {
        // validation for constraint: string
        if (!is_null($retrieveDate) && !is_string($retrieveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retrieveDate, true), gettype($retrieveDate)), __LINE__);
        }
        $this->retrieveDate = $retrieveDate;
        return $this;
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\UpdateFirmwareRequest
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get retries value
     * @return int|null
     */
    public function getRetries()
    {
        return $this->retries;
    }
    /**
     * Set retries value
     * @param int $retries
     * @return \StructType\UpdateFirmwareRequest
     */
    public function setRetries($retries = null)
    {
        // validation for constraint: int
        if (!is_null($retries) && !(is_int($retries) || ctype_digit($retries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retries, true), gettype($retries)), __LINE__);
        }
        $this->retries = $retries;
        return $this;
    }
    /**
     * Get retryInterval value
     * @return int|null
     */
    public function getRetryInterval()
    {
        return $this->retryInterval;
    }
    /**
     * Set retryInterval value
     * @param int $retryInterval
     * @return \StructType\UpdateFirmwareRequest
     */
    public function setRetryInterval($retryInterval = null)
    {
        // validation for constraint: int
        if (!is_null($retryInterval) && !(is_int($retryInterval) || ctype_digit($retryInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryInterval, true), gettype($retryInterval)), __LINE__);
        }
        $this->retryInterval = $retryInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateFirmwareRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
