<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLocalListVersionResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the GetLocalListVersion.conf PDU
 * @subpackage Structs
 */
class GetLocalListVersionResponse extends AbstractStructBase
{
    /**
     * The listVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $listVersion;
    /**
     * Constructor method for GetLocalListVersionResponse
     * @uses GetLocalListVersionResponse::setListVersion()
     * @param int $listVersion
     */
    public function __construct($listVersion = null)
    {
        $this
            ->setListVersion($listVersion);
    }
    /**
     * Get listVersion value
     * @return int
     */
    public function getListVersion()
    {
        return $this->listVersion;
    }
    /**
     * Set listVersion value
     * @param int $listVersion
     * @return \StructType\GetLocalListVersionResponse
     */
    public function setListVersion($listVersion = null)
    {
        // validation for constraint: int
        if (!is_null($listVersion) && !(is_int($listVersion) || ctype_digit($listVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listVersion, true), gettype($listVersion)), __LINE__);
        }
        $this->listVersion = $listVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLocalListVersionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
