<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigurationResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the GetConfiguration.req PDU
 * @subpackage Structs
 */
class GetConfigurationResponse extends AbstractStructBase
{
    /**
     * The configurationKey
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValue[]
     */
    public $configurationKey;
    /**
     * The unknownKey
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $unknownKey;
    /**
     * Constructor method for GetConfigurationResponse
     * @uses GetConfigurationResponse::setConfigurationKey()
     * @uses GetConfigurationResponse::setUnknownKey()
     * @param \StructType\KeyValue[] $configurationKey
     * @param string[] $unknownKey
     */
    public function __construct(array $configurationKey = array(), array $unknownKey = array())
    {
        $this
            ->setConfigurationKey($configurationKey)
            ->setUnknownKey($unknownKey);
    }
    /**
     * Get configurationKey value
     * @return \StructType\KeyValue[]|null
     */
    public function getConfigurationKey()
    {
        return $this->configurationKey;
    }
    /**
     * This method is responsible for validating the values passed to the setConfigurationKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConfigurationKey method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConfigurationKeyForArrayConstraintsFromSetConfigurationKey(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConfigurationResponseConfigurationKeyItem) {
            // validation for constraint: itemType
            if (!$getConfigurationResponseConfigurationKeyItem instanceof \StructType\KeyValue) {
                $invalidValues[] = is_object($getConfigurationResponseConfigurationKeyItem) ? get_class($getConfigurationResponseConfigurationKeyItem) : sprintf('%s(%s)', gettype($getConfigurationResponseConfigurationKeyItem), var_export($getConfigurationResponseConfigurationKeyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The configurationKey property can only contain items of type \StructType\KeyValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set configurationKey value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValue[] $configurationKey
     * @return \StructType\GetConfigurationResponse
     */
    public function setConfigurationKey(array $configurationKey = array())
    {
        // validation for constraint: array
        if ('' !== ($configurationKeyArrayErrorMessage = self::validateConfigurationKeyForArrayConstraintsFromSetConfigurationKey($configurationKey))) {
            throw new \InvalidArgumentException($configurationKeyArrayErrorMessage, __LINE__);
        }
        $this->configurationKey = $configurationKey;
        return $this;
    }
    /**
     * Add item to configurationKey value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValue $item
     * @return \StructType\GetConfigurationResponse
     */
    public function addToConfigurationKey(\StructType\KeyValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValue) {
            throw new \InvalidArgumentException(sprintf('The configurationKey property can only contain items of type \StructType\KeyValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->configurationKey[] = $item;
        return $this;
    }
    /**
     * Get unknownKey value
     * @return string[]|null
     */
    public function getUnknownKey()
    {
        return $this->unknownKey;
    }
    /**
     * This method is responsible for validating the values passed to the setUnknownKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnknownKey method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnknownKeyForArrayConstraintsFromSetUnknownKey(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConfigurationResponseUnknownKeyItem) {
            // validation for constraint: itemType
            if (!is_string($getConfigurationResponseUnknownKeyItem)) {
                $invalidValues[] = is_object($getConfigurationResponseUnknownKeyItem) ? get_class($getConfigurationResponseUnknownKeyItem) : sprintf('%s(%s)', gettype($getConfigurationResponseUnknownKeyItem), var_export($getConfigurationResponseUnknownKeyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unknownKey property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unknownKey value
     * @throws \InvalidArgumentException
     * @param string[] $unknownKey
     * @return \StructType\GetConfigurationResponse
     */
    public function setUnknownKey(array $unknownKey = array())
    {
        // validation for constraint: array
        if ('' !== ($unknownKeyArrayErrorMessage = self::validateUnknownKeyForArrayConstraintsFromSetUnknownKey($unknownKey))) {
            throw new \InvalidArgumentException($unknownKeyArrayErrorMessage, __LINE__);
        }
        $this->unknownKey = $unknownKey;
        return $this;
    }
    /**
     * Add item to unknownKey value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetConfigurationResponse
     */
    public function addToUnknownKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The unknownKey property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unknownKey[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConfigurationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
