<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigurationRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the GetConfiguration.req PDU
 * @subpackage Structs
 */
class GetConfigurationRequest extends AbstractStructBase
{
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $key;
    /**
     * Constructor method for GetConfigurationRequest
     * @uses GetConfigurationRequest::setKey()
     * @param string[] $key
     */
    public function __construct(array $key = array())
    {
        $this
            ->setKey($key);
    }
    /**
     * Get key value
     * @return string[]|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * This method is responsible for validating the values passed to the setKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKey method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyForArrayConstraintsFromSetKey(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConfigurationRequestKeyItem) {
            // validation for constraint: itemType
            if (!is_string($getConfigurationRequestKeyItem)) {
                $invalidValues[] = is_object($getConfigurationRequestKeyItem) ? get_class($getConfigurationRequestKeyItem) : sprintf('%s(%s)', gettype($getConfigurationRequestKeyItem), var_export($getConfigurationRequestKeyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The key property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set key value
     * @throws \InvalidArgumentException
     * @param string[] $key
     * @return \StructType\GetConfigurationRequest
     */
    public function setKey(array $key = array())
    {
        // validation for constraint: array
        if ('' !== ($keyArrayErrorMessage = self::validateKeyForArrayConstraintsFromSetKey($key))) {
            throw new \InvalidArgumentException($keyArrayErrorMessage, __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Add item to key value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetConfigurationRequest
     */
    public function addToKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The key property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->key[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConfigurationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
