<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelReservationRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the CancelReservation.req PDU
 * @subpackage Structs
 */
class CancelReservationRequest extends AbstractStructBase
{
    /**
     * The reservationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reservationId;
    /**
     * Constructor method for CancelReservationRequest
     * @uses CancelReservationRequest::setReservationId()
     * @param int $reservationId
     */
    public function __construct($reservationId = null)
    {
        $this
            ->setReservationId($reservationId);
    }
    /**
     * Get reservationId value
     * @return int
     */
    public function getReservationId()
    {
        return $this->reservationId;
    }
    /**
     * Set reservationId value
     * @param int $reservationId
     * @return \StructType\CancelReservationRequest
     */
    public function setReservationId($reservationId = null)
    {
        // validation for constraint: int
        if (!is_null($reservationId) && !(is_int($reservationId) || ctype_digit($reservationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationId, true), gettype($reservationId)), __LINE__);
        }
        $this->reservationId = $reservationId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelReservationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
