<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorisationData StructType
 * @subpackage Structs
 */
class AuthorisationData extends AbstractStructBase
{
    /**
     * The idTag
     * Meta information extracted from the WSDL
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idTag;
    /**
     * The idTagInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdTagInfo
     */
    public $idTagInfo;
    /**
     * Constructor method for AuthorisationData
     * @uses AuthorisationData::setIdTag()
     * @uses AuthorisationData::setIdTagInfo()
     * @param string $idTag
     * @param \StructType\IdTagInfo $idTagInfo
     */
    public function __construct($idTag = null, \StructType\IdTagInfo $idTagInfo = null)
    {
        $this
            ->setIdTag($idTag)
            ->setIdTagInfo($idTagInfo);
    }
    /**
     * Get idTag value
     * @return string
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\AuthorisationData
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTag, true), gettype($idTag)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($idTag) && mb_strlen($idTag) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Get idTagInfo value
     * @return \StructType\IdTagInfo|null
     */
    public function getIdTagInfo()
    {
        return $this->idTagInfo;
    }
    /**
     * Set idTagInfo value
     * @param \StructType\IdTagInfo $idTagInfo
     * @return \StructType\AuthorisationData
     */
    public function setIdTagInfo(\StructType\IdTagInfo $idTagInfo = null)
    {
        $this->idTagInfo = $idTagInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorisationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
