<?php

namespace EnumType;

/**
 * This class stands for ResetType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the reset-type-value
 * @subpackage Enumerations
 */
class ResetType
{
    /**
     * Constant for value 'Hard'
     * @return string 'Hard'
     */
    const VALUE_HARD = 'Hard';
    /**
     * Constant for value 'Soft'
     * @return string 'Soft'
     */
    const VALUE_SOFT = 'Soft';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HARD
     * @uses self::VALUE_SOFT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HARD,
            self::VALUE_SOFT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
