<?php

namespace EnumType;

/**
 * This class stands for AuthorizationStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the authorization-status-value
 * @subpackage Enumerations
 */
class AuthorizationStatus
{
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Blocked'
     * @return string 'Blocked'
     */
    const VALUE_BLOCKED = 'Blocked';
    /**
     * Constant for value 'Expired'
     * @return string 'Expired'
     */
    const VALUE_EXPIRED = 'Expired';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Constant for value 'ConcurrentTx'
     * @return string 'ConcurrentTx'
     */
    const VALUE_CONCURRENT_TX = 'ConcurrentTx';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_BLOCKED
     * @uses self::VALUE_EXPIRED
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_CONCURRENT_TX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPTED,
            self::VALUE_BLOCKED,
            self::VALUE_EXPIRED,
            self::VALUE_INVALID,
            self::VALUE_CONCURRENT_TX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
