<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendLocalListResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the SendLocalList.conf PDU
 * @subpackage Structs
 */
class SendLocalListResponse extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The hash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hash;
    /**
     * Constructor method for SendLocalListResponse
     * @uses SendLocalListResponse::setStatus()
     * @uses SendLocalListResponse::setHash()
     * @param string $status
     * @param string $hash
     */
    public function __construct($status = null, $hash = null)
    {
        $this
            ->setStatus($status)
            ->setHash($hash);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\UpdateStatus::valueIsValid()
     * @uses \EnumType\UpdateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SendLocalListResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UpdateStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\UpdateStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get hash value
     * @return string|null
     */
    public function getHash()
    {
        return $this->hash;
    }
    /**
     * Set hash value
     * @param string $hash
     * @return \StructType\SendLocalListResponse
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hash, true), gettype($hash)), __LINE__);
        }
        $this->hash = $hash;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendLocalListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
