<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendLocalListRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the SendLocalList.req PDU
 * @subpackage Structs
 */
class SendLocalListRequest extends AbstractStructBase
{
    /**
     * The updateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $updateType;
    /**
     * The listVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $listVersion;
    /**
     * The localAuthorisationList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AuthorisationData[]
     */
    public $localAuthorisationList;
    /**
     * The hash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hash;
    /**
     * Constructor method for SendLocalListRequest
     * @uses SendLocalListRequest::setUpdateType()
     * @uses SendLocalListRequest::setListVersion()
     * @uses SendLocalListRequest::setLocalAuthorisationList()
     * @uses SendLocalListRequest::setHash()
     * @param string $updateType
     * @param int $listVersion
     * @param \StructType\AuthorisationData[] $localAuthorisationList
     * @param string $hash
     */
    public function __construct($updateType = null, $listVersion = null, array $localAuthorisationList = array(), $hash = null)
    {
        $this
            ->setUpdateType($updateType)
            ->setListVersion($listVersion)
            ->setLocalAuthorisationList($localAuthorisationList)
            ->setHash($hash);
    }
    /**
     * Get updateType value
     * @return string
     */
    public function getUpdateType()
    {
        return $this->updateType;
    }
    /**
     * Set updateType value
     * @uses \EnumType\UpdateType::valueIsValid()
     * @uses \EnumType\UpdateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateType
     * @return \StructType\SendLocalListRequest
     */
    public function setUpdateType($updateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UpdateType::valueIsValid($updateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UpdateType', is_array($updateType) ? implode(', ', $updateType) : var_export($updateType, true), implode(', ', \EnumType\UpdateType::getValidValues())), __LINE__);
        }
        $this->updateType = $updateType;
        return $this;
    }
    /**
     * Get listVersion value
     * @return int
     */
    public function getListVersion()
    {
        return $this->listVersion;
    }
    /**
     * Set listVersion value
     * @param int $listVersion
     * @return \StructType\SendLocalListRequest
     */
    public function setListVersion($listVersion = null)
    {
        // validation for constraint: int
        if (!is_null($listVersion) && !(is_int($listVersion) || ctype_digit($listVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listVersion, true), gettype($listVersion)), __LINE__);
        }
        $this->listVersion = $listVersion;
        return $this;
    }
    /**
     * Get localAuthorisationList value
     * @return \StructType\AuthorisationData[]|null
     */
    public function getLocalAuthorisationList()
    {
        return $this->localAuthorisationList;
    }
    /**
     * This method is responsible for validating the values passed to the setLocalAuthorisationList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocalAuthorisationList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocalAuthorisationListForArrayConstraintsFromSetLocalAuthorisationList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sendLocalListRequestLocalAuthorisationListItem) {
            // validation for constraint: itemType
            if (!$sendLocalListRequestLocalAuthorisationListItem instanceof \StructType\AuthorisationData) {
                $invalidValues[] = is_object($sendLocalListRequestLocalAuthorisationListItem) ? get_class($sendLocalListRequestLocalAuthorisationListItem) : sprintf('%s(%s)', gettype($sendLocalListRequestLocalAuthorisationListItem), var_export($sendLocalListRequestLocalAuthorisationListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The localAuthorisationList property can only contain items of type \StructType\AuthorisationData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set localAuthorisationList value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorisationData[] $localAuthorisationList
     * @return \StructType\SendLocalListRequest
     */
    public function setLocalAuthorisationList(array $localAuthorisationList = array())
    {
        // validation for constraint: array
        if ('' !== ($localAuthorisationListArrayErrorMessage = self::validateLocalAuthorisationListForArrayConstraintsFromSetLocalAuthorisationList($localAuthorisationList))) {
            throw new \InvalidArgumentException($localAuthorisationListArrayErrorMessage, __LINE__);
        }
        $this->localAuthorisationList = $localAuthorisationList;
        return $this;
    }
    /**
     * Add item to localAuthorisationList value
     * @throws \InvalidArgumentException
     * @param \StructType\AuthorisationData $item
     * @return \StructType\SendLocalListRequest
     */
    public function addToLocalAuthorisationList(\StructType\AuthorisationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AuthorisationData) {
            throw new \InvalidArgumentException(sprintf('The localAuthorisationList property can only contain items of type \StructType\AuthorisationData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->localAuthorisationList[] = $item;
        return $this;
    }
    /**
     * Get hash value
     * @return string|null
     */
    public function getHash()
    {
        return $this->hash;
    }
    /**
     * Set hash value
     * @param string $hash
     * @return \StructType\SendLocalListRequest
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hash, true), gettype($hash)), __LINE__);
        }
        $this->hash = $hash;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendLocalListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
