<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReserveNowRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the ReserveNow.req PDU
 * @subpackage Structs
 */
class ReserveNowRequest extends AbstractStructBase
{
    /**
     * The connectorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $connectorId;
    /**
     * The expiryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expiryDate;
    /**
     * The idTag
     * Meta information extracted from the WSDL
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $idTag;
    /**
     * The reservationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $reservationId;
    /**
     * The parentIdTag
     * Meta information extracted from the WSDL
     * - documentation: Type of string defining identification token, e.g. RFID or credit card number. To be treated as case insensitive.
     * - base: s:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parentIdTag;
    /**
     * Constructor method for ReserveNowRequest
     * @uses ReserveNowRequest::setConnectorId()
     * @uses ReserveNowRequest::setExpiryDate()
     * @uses ReserveNowRequest::setIdTag()
     * @uses ReserveNowRequest::setReservationId()
     * @uses ReserveNowRequest::setParentIdTag()
     * @param int $connectorId
     * @param string $expiryDate
     * @param string $idTag
     * @param int $reservationId
     * @param string $parentIdTag
     */
    public function __construct($connectorId = null, $expiryDate = null, $idTag = null, $reservationId = null, $parentIdTag = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setExpiryDate($expiryDate)
            ->setIdTag($idTag)
            ->setReservationId($reservationId)
            ->setParentIdTag($parentIdTag);
    }
    /**
     * Get connectorId value
     * @return int
     */
    public function getConnectorId()
    {
        return $this->connectorId;
    }
    /**
     * Set connectorId value
     * @param int $connectorId
     * @return \StructType\ReserveNowRequest
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: int
        if (!is_null($connectorId) && !(is_int($connectorId) || ctype_digit($connectorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectorId, true), gettype($connectorId)), __LINE__);
        }
        $this->connectorId = $connectorId;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \StructType\ReserveNowRequest
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get idTag value
     * @return string
     */
    public function getIdTag()
    {
        return $this->idTag;
    }
    /**
     * Set idTag value
     * @param string $idTag
     * @return \StructType\ReserveNowRequest
     */
    public function setIdTag($idTag = null)
    {
        // validation for constraint: string
        if (!is_null($idTag) && !is_string($idTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTag, true), gettype($idTag)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($idTag) && mb_strlen($idTag) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($idTag)), __LINE__);
        }
        $this->idTag = $idTag;
        return $this;
    }
    /**
     * Get reservationId value
     * @return int
     */
    public function getReservationId()
    {
        return $this->reservationId;
    }
    /**
     * Set reservationId value
     * @param int $reservationId
     * @return \StructType\ReserveNowRequest
     */
    public function setReservationId($reservationId = null)
    {
        // validation for constraint: int
        if (!is_null($reservationId) && !(is_int($reservationId) || ctype_digit($reservationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationId, true), gettype($reservationId)), __LINE__);
        }
        $this->reservationId = $reservationId;
        return $this;
    }
    /**
     * Get parentIdTag value
     * @return string|null
     */
    public function getParentIdTag()
    {
        return $this->parentIdTag;
    }
    /**
     * Set parentIdTag value
     * @param string $parentIdTag
     * @return \StructType\ReserveNowRequest
     */
    public function setParentIdTag($parentIdTag = null)
    {
        // validation for constraint: string
        if (!is_null($parentIdTag) && !is_string($parentIdTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentIdTag, true), gettype($parentIdTag)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($parentIdTag) && mb_strlen($parentIdTag) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($parentIdTag)), __LINE__);
        }
        $this->parentIdTag = $parentIdTag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReserveNowRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
