<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDiagnosticsRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the GetDiagnostics.req PDU
 * @subpackage Structs
 */
class GetDiagnosticsRequest extends AbstractStructBase
{
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $location;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startTime;
    /**
     * The stopTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stopTime;
    /**
     * The retries
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $retries;
    /**
     * The retryInterval
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $retryInterval;
    /**
     * Constructor method for GetDiagnosticsRequest
     * @uses GetDiagnosticsRequest::setLocation()
     * @uses GetDiagnosticsRequest::setStartTime()
     * @uses GetDiagnosticsRequest::setStopTime()
     * @uses GetDiagnosticsRequest::setRetries()
     * @uses GetDiagnosticsRequest::setRetryInterval()
     * @param string $location
     * @param string $startTime
     * @param string $stopTime
     * @param int $retries
     * @param int $retryInterval
     */
    public function __construct($location = null, $startTime = null, $stopTime = null, $retries = null, $retryInterval = null)
    {
        $this
            ->setLocation($location)
            ->setStartTime($startTime)
            ->setStopTime($stopTime)
            ->setRetries($retries)
            ->setRetryInterval($retryInterval);
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\GetDiagnosticsRequest
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @param string $startTime
     * @return \StructType\GetDiagnosticsRequest
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get stopTime value
     * @return string|null
     */
    public function getStopTime()
    {
        return $this->stopTime;
    }
    /**
     * Set stopTime value
     * @param string $stopTime
     * @return \StructType\GetDiagnosticsRequest
     */
    public function setStopTime($stopTime = null)
    {
        // validation for constraint: string
        if (!is_null($stopTime) && !is_string($stopTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopTime, true), gettype($stopTime)), __LINE__);
        }
        $this->stopTime = $stopTime;
        return $this;
    }
    /**
     * Get retries value
     * @return int|null
     */
    public function getRetries()
    {
        return $this->retries;
    }
    /**
     * Set retries value
     * @param int $retries
     * @return \StructType\GetDiagnosticsRequest
     */
    public function setRetries($retries = null)
    {
        // validation for constraint: int
        if (!is_null($retries) && !(is_int($retries) || ctype_digit($retries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retries, true), gettype($retries)), __LINE__);
        }
        $this->retries = $retries;
        return $this;
    }
    /**
     * Get retryInterval value
     * @return int|null
     */
    public function getRetryInterval()
    {
        return $this->retryInterval;
    }
    /**
     * Set retryInterval value
     * @param int $retryInterval
     * @return \StructType\GetDiagnosticsRequest
     */
    public function setRetryInterval($retryInterval = null)
    {
        // validation for constraint: int
        if (!is_null($retryInterval) && !(is_int($retryInterval) || ctype_digit($retryInterval))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryInterval, true), gettype($retryInterval)), __LINE__);
        }
        $this->retryInterval = $retryInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDiagnosticsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
