<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unlock ServiceType
 * @subpackage Services
 */
class Unlock extends AbstractSoapClientBase
{
    /**
     * Sets the ChargeBoxIdentity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $chargeBoxIdentity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderChargeBoxIdentity($chargeBoxIdentity, $nameSpace = 'urn://Ocpp/Cp/2012/06/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'chargeBoxIdentity', $chargeBoxIdentity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UnlockConnector
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: chargeBoxIdentity
     * - SOAPHeaderNamespaces: urn://Ocpp/Cp/2012/06/
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnlockConnectorRequest $parameters
     * @return \StructType\UnlockConnectorResponse|bool
     */
    public function UnlockConnector(\StructType\UnlockConnectorRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnlockConnector($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnlockConnectorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
