<?php

namespace EnumType;

/**
 * This class stands for UpdateStatus EnumType
 * @subpackage Enumerations
 */
class UpdateStatus
{
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'HashError'
     * @return string 'HashError'
     */
    const VALUE_HASH_ERROR = 'HashError';
    /**
     * Constant for value 'NotSupported'
     * @return string 'NotSupported'
     */
    const VALUE_NOT_SUPPORTED = 'NotSupported';
    /**
     * Constant for value 'VersionMismatch'
     * @return string 'VersionMismatch'
     */
    const VALUE_VERSION_MISMATCH = 'VersionMismatch';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_HASH_ERROR
     * @uses self::VALUE_NOT_SUPPORTED
     * @uses self::VALUE_VERSION_MISMATCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPTED,
            self::VALUE_FAILED,
            self::VALUE_HASH_ERROR,
            self::VALUE_NOT_SUPPORTED,
            self::VALUE_VERSION_MISMATCH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
