<?php

namespace EnumType;

/**
 * This class stands for ConfigurationStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the configuration-status-value
 * @subpackage Enumerations
 */
class ConfigurationStatus
{
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'NotSupported'
     * @return string 'NotSupported'
     */
    const VALUE_NOT_SUPPORTED = 'NotSupported';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_NOT_SUPPORTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPTED,
            self::VALUE_REJECTED,
            self::VALUE_NOT_SUPPORTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
