<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rBankModel StructType
 * @subpackage Structs
 */
class RBankModel extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The rbCommissionPayer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rbCommissionPayer;
    /**
     * The rbankStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rbankStatus;
    /**
     * The shopId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shopId;
    /**
     * The transferCommission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $transferCommission;
    /**
     * Constructor method for rBankModel
     * @uses RBankModel::setOrderNumber()
     * @uses RBankModel::setRbCommissionPayer()
     * @uses RBankModel::setRbankStatus()
     * @uses RBankModel::setShopId()
     * @uses RBankModel::setTransferCommission()
     * @param string $orderNumber
     * @param int $rbCommissionPayer
     * @param int $rbankStatus
     * @param int $shopId
     * @param int $transferCommission
     */
    public function __construct($orderNumber = null, $rbCommissionPayer = null, $rbankStatus = null, $shopId = null, $transferCommission = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setRbCommissionPayer($rbCommissionPayer)
            ->setRbankStatus($rbankStatus)
            ->setShopId($shopId)
            ->setTransferCommission($transferCommission);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\RBankModel
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get rbCommissionPayer value
     * @return int|null
     */
    public function getRbCommissionPayer()
    {
        return $this->rbCommissionPayer;
    }
    /**
     * Set rbCommissionPayer value
     * @param int $rbCommissionPayer
     * @return \StructType\RBankModel
     */
    public function setRbCommissionPayer($rbCommissionPayer = null)
    {
        // validation for constraint: int
        if (!is_null($rbCommissionPayer) && !is_numeric($rbCommissionPayer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rbCommissionPayer)), __LINE__);
        }
        $this->rbCommissionPayer = $rbCommissionPayer;
        return $this;
    }
    /**
     * Get rbankStatus value
     * @return int|null
     */
    public function getRbankStatus()
    {
        return $this->rbankStatus;
    }
    /**
     * Set rbankStatus value
     * @param int $rbankStatus
     * @return \StructType\RBankModel
     */
    public function setRbankStatus($rbankStatus = null)
    {
        // validation for constraint: int
        if (!is_null($rbankStatus) && !is_numeric($rbankStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rbankStatus)), __LINE__);
        }
        $this->rbankStatus = $rbankStatus;
        return $this;
    }
    /**
     * Get shopId value
     * @return int|null
     */
    public function getShopId()
    {
        return $this->shopId;
    }
    /**
     * Set shopId value
     * @param int $shopId
     * @return \StructType\RBankModel
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: int
        if (!is_null($shopId) && !is_numeric($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shopId)), __LINE__);
        }
        $this->shopId = $shopId;
        return $this;
    }
    /**
     * Get transferCommission value
     * @return int|null
     */
    public function getTransferCommission()
    {
        return $this->transferCommission;
    }
    /**
     * Set transferCommission value
     * @param int $transferCommission
     * @return \StructType\RBankModel
     */
    public function setTransferCommission($transferCommission = null)
    {
        // validation for constraint: int
        if (!is_null($transferCommission) && !is_numeric($transferCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transferCommission)), __LINE__);
        }
        $this->transferCommission = $transferCommission;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RBankModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
