<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentStatusModel StructType
 * @subpackage Structs
 */
class PaymentStatusModel extends AbstractStructBase
{
    /**
     * The accessPoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $accessPoint;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The paymentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentType;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $price;
    /**
     * The shopId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shopId;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The updateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updateTime;
    /**
     * Constructor method for paymentStatusModel
     * @uses PaymentStatusModel::setAccessPoint()
     * @uses PaymentStatusModel::setErrorCode()
     * @uses PaymentStatusModel::setOperator()
     * @uses PaymentStatusModel::setOrderNumber()
     * @uses PaymentStatusModel::setPaymentType()
     * @uses PaymentStatusModel::setPrice()
     * @uses PaymentStatusModel::setShopId()
     * @uses PaymentStatusModel::setStatus()
     * @uses PaymentStatusModel::setUpdateTime()
     * @param int $accessPoint
     * @param string $errorCode
     * @param string $operator
     * @param string $orderNumber
     * @param int $paymentType
     * @param int $price
     * @param int $shopId
     * @param string $status
     * @param string $updateTime
     */
    public function __construct($accessPoint = null, $errorCode = null, $operator = null, $orderNumber = null, $paymentType = null, $price = null, $shopId = null, $status = null, $updateTime = null)
    {
        $this
            ->setAccessPoint($accessPoint)
            ->setErrorCode($errorCode)
            ->setOperator($operator)
            ->setOrderNumber($orderNumber)
            ->setPaymentType($paymentType)
            ->setPrice($price)
            ->setShopId($shopId)
            ->setStatus($status)
            ->setUpdateTime($updateTime);
    }
    /**
     * Get accessPoint value
     * @return int|null
     */
    public function getAccessPoint()
    {
        return $this->accessPoint;
    }
    /**
     * Set accessPoint value
     * @param int $accessPoint
     * @return \StructType\PaymentStatusModel
     */
    public function setAccessPoint($accessPoint = null)
    {
        // validation for constraint: int
        if (!is_null($accessPoint) && !is_numeric($accessPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accessPoint)), __LINE__);
        }
        $this->accessPoint = $accessPoint;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\PaymentStatusModel
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @param string $operator
     * @return \StructType\PaymentStatusModel
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: string
        if (!is_null($operator) && !is_string($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operator)), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\PaymentStatusModel
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\PaymentStatusModel
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !is_numeric($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get price value
     * @return int|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param int $price
     * @return \StructType\PaymentStatusModel
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !is_numeric($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get shopId value
     * @return int|null
     */
    public function getShopId()
    {
        return $this->shopId;
    }
    /**
     * Set shopId value
     * @param int $shopId
     * @return \StructType\PaymentStatusModel
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: int
        if (!is_null($shopId) && !is_numeric($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shopId)), __LINE__);
        }
        $this->shopId = $shopId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\PaymentStatusModel
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get updateTime value
     * @return string|null
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
    /**
     * Set updateTime value
     * @param string $updateTime
     * @return \StructType\PaymentStatusModel
     */
    public function setUpdateTime($updateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTime) && !is_string($updateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTime)), __LINE__);
        }
        $this->updateTime = $updateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentStatusModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
