<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderStatusModel StructType
 * @subpackage Structs
 */
class OrderStatusModel extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $orderNumber;
    /**
     * The statusName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $statusName;
    /**
     * Constructor method for orderStatusModel
     * @uses OrderStatusModel::setOrderNumber()
     * @uses OrderStatusModel::setStatusName()
     * @param string[] $orderNumber
     * @param string $statusName
     */
    public function __construct(array $orderNumber = array(), $statusName = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setStatusName($statusName);
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $orderNumber
     * @return \StructType\OrderStatusModel
     */
    public function setOrderNumber(array $orderNumber = array())
    {
        foreach ($orderNumber as $orderStatusModelOrderNumberItem) {
            // validation for constraint: itemType
            if (!is_string($orderStatusModelOrderNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($orderStatusModelOrderNumberItem) ? get_class($orderStatusModelOrderNumberItem) : gettype($orderStatusModelOrderNumberItem)), __LINE__);
            }
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Add item to orderNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OrderStatusModel
     */
    public function addToOrderNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderNumber[] = $item;
        return $this;
    }
    /**
     * Get statusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->statusName;
    }
    /**
     * Set statusName value
     * @param string $statusName
     * @return \StructType\OrderStatusModel
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusName)), __LINE__);
        }
        $this->statusName = $statusName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderStatusModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
