<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderSearchModel StructType
 * @subpackage Structs
 */
class OrderSearchModel extends AbstractStructBase
{
    /**
     * The asuraku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $asuraku;
    /**
     * The cardSearchModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CardSearchModel
     */
    public $cardSearchModel;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The coupon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $coupon;
    /**
     * The dateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $dateType;
    /**
     * The delivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $delivery;
    /**
     * The drug
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $drug;
    /**
     * The enclosureStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $enclosureStatus;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The itemName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The itemNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemNumber;
    /**
     * The mailAddressType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $mailAddressType;
    /**
     * The modify
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $modify;
    /**
     * The orderSite
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $orderSite;
    /**
     * The orderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $orderType;
    /**
     * The ordererKana
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ordererKana;
    /**
     * The ordererMailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ordererMailAddress;
    /**
     * The ordererName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ordererName;
    /**
     * The ordererPhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ordererPhoneNumber;
    /**
     * The overseas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $overseas;
    /**
     * The pointStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $pointStatus;
    /**
     * The pointUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pointUsed;
    /**
     * The rbankStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $rbankStatus;
    /**
     * The reserveNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reserveNumber;
    /**
     * The senderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senderName;
    /**
     * The senderPhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senderPhoneNumber;
    /**
     * The settlement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $settlement;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $status;
    /**
     * Constructor method for orderSearchModel
     * @uses OrderSearchModel::setAsuraku()
     * @uses OrderSearchModel::setCardSearchModel()
     * @uses OrderSearchModel::setComment()
     * @uses OrderSearchModel::setCoupon()
     * @uses OrderSearchModel::setDateType()
     * @uses OrderSearchModel::setDelivery()
     * @uses OrderSearchModel::setDrug()
     * @uses OrderSearchModel::setEnclosureStatus()
     * @uses OrderSearchModel::setEndDate()
     * @uses OrderSearchModel::setItemName()
     * @uses OrderSearchModel::setItemNumber()
     * @uses OrderSearchModel::setMailAddressType()
     * @uses OrderSearchModel::setModify()
     * @uses OrderSearchModel::setOrderSite()
     * @uses OrderSearchModel::setOrderType()
     * @uses OrderSearchModel::setOrdererKana()
     * @uses OrderSearchModel::setOrdererMailAddress()
     * @uses OrderSearchModel::setOrdererName()
     * @uses OrderSearchModel::setOrdererPhoneNumber()
     * @uses OrderSearchModel::setOverseas()
     * @uses OrderSearchModel::setPointStatus()
     * @uses OrderSearchModel::setPointUsed()
     * @uses OrderSearchModel::setRbankStatus()
     * @uses OrderSearchModel::setReserveNumber()
     * @uses OrderSearchModel::setSenderName()
     * @uses OrderSearchModel::setSenderPhoneNumber()
     * @uses OrderSearchModel::setSettlement()
     * @uses OrderSearchModel::setStartDate()
     * @uses OrderSearchModel::setStatus()
     * @param bool $asuraku
     * @param \StructType\CardSearchModel $cardSearchModel
     * @param string $comment
     * @param bool $coupon
     * @param int $dateType
     * @param string $delivery
     * @param bool $drug
     * @param int[] $enclosureStatus
     * @param string $endDate
     * @param string $itemName
     * @param string $itemNumber
     * @param int[] $mailAddressType
     * @param bool $modify
     * @param int[] $orderSite
     * @param int[] $orderType
     * @param string $ordererKana
     * @param string $ordererMailAddress
     * @param string $ordererName
     * @param string $ordererPhoneNumber
     * @param bool $overseas
     * @param int[] $pointStatus
     * @param bool $pointUsed
     * @param int[] $rbankStatus
     * @param string $reserveNumber
     * @param string $senderName
     * @param string $senderPhoneNumber
     * @param string $settlement
     * @param string $startDate
     * @param string[] $status
     */
    public function __construct($asuraku = null, \StructType\CardSearchModel $cardSearchModel = null, $comment = null, $coupon = null, $dateType = null, $delivery = null, $drug = null, array $enclosureStatus = array(), $endDate = null, $itemName = null, $itemNumber = null, array $mailAddressType = array(), $modify = null, array $orderSite = array(), array $orderType = array(), $ordererKana = null, $ordererMailAddress = null, $ordererName = null, $ordererPhoneNumber = null, $overseas = null, array $pointStatus = array(), $pointUsed = null, array $rbankStatus = array(), $reserveNumber = null, $senderName = null, $senderPhoneNumber = null, $settlement = null, $startDate = null, array $status = array())
    {
        $this
            ->setAsuraku($asuraku)
            ->setCardSearchModel($cardSearchModel)
            ->setComment($comment)
            ->setCoupon($coupon)
            ->setDateType($dateType)
            ->setDelivery($delivery)
            ->setDrug($drug)
            ->setEnclosureStatus($enclosureStatus)
            ->setEndDate($endDate)
            ->setItemName($itemName)
            ->setItemNumber($itemNumber)
            ->setMailAddressType($mailAddressType)
            ->setModify($modify)
            ->setOrderSite($orderSite)
            ->setOrderType($orderType)
            ->setOrdererKana($ordererKana)
            ->setOrdererMailAddress($ordererMailAddress)
            ->setOrdererName($ordererName)
            ->setOrdererPhoneNumber($ordererPhoneNumber)
            ->setOverseas($overseas)
            ->setPointStatus($pointStatus)
            ->setPointUsed($pointUsed)
            ->setRbankStatus($rbankStatus)
            ->setReserveNumber($reserveNumber)
            ->setSenderName($senderName)
            ->setSenderPhoneNumber($senderPhoneNumber)
            ->setSettlement($settlement)
            ->setStartDate($startDate)
            ->setStatus($status);
    }
    /**
     * Get asuraku value
     * @return bool|null
     */
    public function getAsuraku()
    {
        return $this->asuraku;
    }
    /**
     * Set asuraku value
     * @param bool $asuraku
     * @return \StructType\OrderSearchModel
     */
    public function setAsuraku($asuraku = null)
    {
        $this->asuraku = $asuraku;
        return $this;
    }
    /**
     * Get cardSearchModel value
     * @return \StructType\CardSearchModel|null
     */
    public function getCardSearchModel()
    {
        return $this->cardSearchModel;
    }
    /**
     * Set cardSearchModel value
     * @param \StructType\CardSearchModel $cardSearchModel
     * @return \StructType\OrderSearchModel
     */
    public function setCardSearchModel(\StructType\CardSearchModel $cardSearchModel = null)
    {
        $this->cardSearchModel = $cardSearchModel;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\OrderSearchModel
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get coupon value
     * @return bool|null
     */
    public function getCoupon()
    {
        return $this->coupon;
    }
    /**
     * Set coupon value
     * @param bool $coupon
     * @return \StructType\OrderSearchModel
     */
    public function setCoupon($coupon = null)
    {
        $this->coupon = $coupon;
        return $this;
    }
    /**
     * Get dateType value
     * @return int|null
     */
    public function getDateType()
    {
        return $this->dateType;
    }
    /**
     * Set dateType value
     * @param int $dateType
     * @return \StructType\OrderSearchModel
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: int
        if (!is_null($dateType) && !is_numeric($dateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dateType)), __LINE__);
        }
        $this->dateType = $dateType;
        return $this;
    }
    /**
     * Get delivery value
     * @return string|null
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @param string $delivery
     * @return \StructType\OrderSearchModel
     */
    public function setDelivery($delivery = null)
    {
        // validation for constraint: string
        if (!is_null($delivery) && !is_string($delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delivery)), __LINE__);
        }
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Get drug value
     * @return bool|null
     */
    public function getDrug()
    {
        return $this->drug;
    }
    /**
     * Set drug value
     * @param bool $drug
     * @return \StructType\OrderSearchModel
     */
    public function setDrug($drug = null)
    {
        $this->drug = $drug;
        return $this;
    }
    /**
     * Get enclosureStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getEnclosureStatus()
    {
        return isset($this->enclosureStatus) ? $this->enclosureStatus : null;
    }
    /**
     * Set enclosureStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $enclosureStatus
     * @return \StructType\OrderSearchModel
     */
    public function setEnclosureStatus(array $enclosureStatus = array())
    {
        foreach ($enclosureStatus as $orderSearchModelEnclosureStatusItem) {
            // validation for constraint: itemType
            if (!is_numeric($orderSearchModelEnclosureStatusItem)) {
                throw new \InvalidArgumentException(sprintf('The enclosureStatus property can only contain items of int, "%s" given', is_object($orderSearchModelEnclosureStatusItem) ? get_class($orderSearchModelEnclosureStatusItem) : gettype($orderSearchModelEnclosureStatusItem)), __LINE__);
            }
        }
        if (is_null($enclosureStatus) || (is_array($enclosureStatus) && empty($enclosureStatus))) {
            unset($this->enclosureStatus);
        } else {
            $this->enclosureStatus = $enclosureStatus;
        }
        return $this;
    }
    /**
     * Add item to enclosureStatus value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderSearchModel
     */
    public function addToEnclosureStatus($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The enclosureStatus property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->enclosureStatus[] = $item;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\OrderSearchModel
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\OrderSearchModel
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get itemNumber value
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->itemNumber;
    }
    /**
     * Set itemNumber value
     * @param string $itemNumber
     * @return \StructType\OrderSearchModel
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemNumber) && !is_string($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemNumber)), __LINE__);
        }
        $this->itemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get mailAddressType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getMailAddressType()
    {
        return isset($this->mailAddressType) ? $this->mailAddressType : null;
    }
    /**
     * Set mailAddressType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $mailAddressType
     * @return \StructType\OrderSearchModel
     */
    public function setMailAddressType(array $mailAddressType = array())
    {
        foreach ($mailAddressType as $orderSearchModelMailAddressTypeItem) {
            // validation for constraint: itemType
            if (!is_numeric($orderSearchModelMailAddressTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The mailAddressType property can only contain items of int, "%s" given', is_object($orderSearchModelMailAddressTypeItem) ? get_class($orderSearchModelMailAddressTypeItem) : gettype($orderSearchModelMailAddressTypeItem)), __LINE__);
            }
        }
        if (is_null($mailAddressType) || (is_array($mailAddressType) && empty($mailAddressType))) {
            unset($this->mailAddressType);
        } else {
            $this->mailAddressType = $mailAddressType;
        }
        return $this;
    }
    /**
     * Add item to mailAddressType value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderSearchModel
     */
    public function addToMailAddressType($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The mailAddressType property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mailAddressType[] = $item;
        return $this;
    }
    /**
     * Get modify value
     * @return bool|null
     */
    public function getModify()
    {
        return $this->modify;
    }
    /**
     * Set modify value
     * @param bool $modify
     * @return \StructType\OrderSearchModel
     */
    public function setModify($modify = null)
    {
        $this->modify = $modify;
        return $this;
    }
    /**
     * Get orderSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getOrderSite()
    {
        return isset($this->orderSite) ? $this->orderSite : null;
    }
    /**
     * Set orderSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $orderSite
     * @return \StructType\OrderSearchModel
     */
    public function setOrderSite(array $orderSite = array())
    {
        foreach ($orderSite as $orderSearchModelOrderSiteItem) {
            // validation for constraint: itemType
            if (!is_numeric($orderSearchModelOrderSiteItem)) {
                throw new \InvalidArgumentException(sprintf('The orderSite property can only contain items of int, "%s" given', is_object($orderSearchModelOrderSiteItem) ? get_class($orderSearchModelOrderSiteItem) : gettype($orderSearchModelOrderSiteItem)), __LINE__);
            }
        }
        if (is_null($orderSite) || (is_array($orderSite) && empty($orderSite))) {
            unset($this->orderSite);
        } else {
            $this->orderSite = $orderSite;
        }
        return $this;
    }
    /**
     * Add item to orderSite value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderSearchModel
     */
    public function addToOrderSite($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The orderSite property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderSite[] = $item;
        return $this;
    }
    /**
     * Get orderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getOrderType()
    {
        return isset($this->orderType) ? $this->orderType : null;
    }
    /**
     * Set orderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $orderType
     * @return \StructType\OrderSearchModel
     */
    public function setOrderType(array $orderType = array())
    {
        foreach ($orderType as $orderSearchModelOrderTypeItem) {
            // validation for constraint: itemType
            if (!is_numeric($orderSearchModelOrderTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The orderType property can only contain items of int, "%s" given', is_object($orderSearchModelOrderTypeItem) ? get_class($orderSearchModelOrderTypeItem) : gettype($orderSearchModelOrderTypeItem)), __LINE__);
            }
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->orderType);
        } else {
            $this->orderType = $orderType;
        }
        return $this;
    }
    /**
     * Add item to orderType value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderSearchModel
     */
    public function addToOrderType($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The orderType property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderType[] = $item;
        return $this;
    }
    /**
     * Get ordererKana value
     * @return string|null
     */
    public function getOrdererKana()
    {
        return $this->ordererKana;
    }
    /**
     * Set ordererKana value
     * @param string $ordererKana
     * @return \StructType\OrderSearchModel
     */
    public function setOrdererKana($ordererKana = null)
    {
        // validation for constraint: string
        if (!is_null($ordererKana) && !is_string($ordererKana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ordererKana)), __LINE__);
        }
        $this->ordererKana = $ordererKana;
        return $this;
    }
    /**
     * Get ordererMailAddress value
     * @return string|null
     */
    public function getOrdererMailAddress()
    {
        return $this->ordererMailAddress;
    }
    /**
     * Set ordererMailAddress value
     * @param string $ordererMailAddress
     * @return \StructType\OrderSearchModel
     */
    public function setOrdererMailAddress($ordererMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ordererMailAddress) && !is_string($ordererMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ordererMailAddress)), __LINE__);
        }
        $this->ordererMailAddress = $ordererMailAddress;
        return $this;
    }
    /**
     * Get ordererName value
     * @return string|null
     */
    public function getOrdererName()
    {
        return $this->ordererName;
    }
    /**
     * Set ordererName value
     * @param string $ordererName
     * @return \StructType\OrderSearchModel
     */
    public function setOrdererName($ordererName = null)
    {
        // validation for constraint: string
        if (!is_null($ordererName) && !is_string($ordererName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ordererName)), __LINE__);
        }
        $this->ordererName = $ordererName;
        return $this;
    }
    /**
     * Get ordererPhoneNumber value
     * @return string|null
     */
    public function getOrdererPhoneNumber()
    {
        return $this->ordererPhoneNumber;
    }
    /**
     * Set ordererPhoneNumber value
     * @param string $ordererPhoneNumber
     * @return \StructType\OrderSearchModel
     */
    public function setOrdererPhoneNumber($ordererPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ordererPhoneNumber) && !is_string($ordererPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ordererPhoneNumber)), __LINE__);
        }
        $this->ordererPhoneNumber = $ordererPhoneNumber;
        return $this;
    }
    /**
     * Get overseas value
     * @return bool|null
     */
    public function getOverseas()
    {
        return $this->overseas;
    }
    /**
     * Set overseas value
     * @param bool $overseas
     * @return \StructType\OrderSearchModel
     */
    public function setOverseas($overseas = null)
    {
        $this->overseas = $overseas;
        return $this;
    }
    /**
     * Get pointStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getPointStatus()
    {
        return isset($this->pointStatus) ? $this->pointStatus : null;
    }
    /**
     * Set pointStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $pointStatus
     * @return \StructType\OrderSearchModel
     */
    public function setPointStatus(array $pointStatus = array())
    {
        foreach ($pointStatus as $orderSearchModelPointStatusItem) {
            // validation for constraint: itemType
            if (!is_numeric($orderSearchModelPointStatusItem)) {
                throw new \InvalidArgumentException(sprintf('The pointStatus property can only contain items of int, "%s" given', is_object($orderSearchModelPointStatusItem) ? get_class($orderSearchModelPointStatusItem) : gettype($orderSearchModelPointStatusItem)), __LINE__);
            }
        }
        if (is_null($pointStatus) || (is_array($pointStatus) && empty($pointStatus))) {
            unset($this->pointStatus);
        } else {
            $this->pointStatus = $pointStatus;
        }
        return $this;
    }
    /**
     * Add item to pointStatus value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderSearchModel
     */
    public function addToPointStatus($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The pointStatus property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pointStatus[] = $item;
        return $this;
    }
    /**
     * Get pointUsed value
     * @return bool|null
     */
    public function getPointUsed()
    {
        return $this->pointUsed;
    }
    /**
     * Set pointUsed value
     * @param bool $pointUsed
     * @return \StructType\OrderSearchModel
     */
    public function setPointUsed($pointUsed = null)
    {
        $this->pointUsed = $pointUsed;
        return $this;
    }
    /**
     * Get rbankStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getRbankStatus()
    {
        return isset($this->rbankStatus) ? $this->rbankStatus : null;
    }
    /**
     * Set rbankStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $rbankStatus
     * @return \StructType\OrderSearchModel
     */
    public function setRbankStatus(array $rbankStatus = array())
    {
        foreach ($rbankStatus as $orderSearchModelRbankStatusItem) {
            // validation for constraint: itemType
            if (!is_numeric($orderSearchModelRbankStatusItem)) {
                throw new \InvalidArgumentException(sprintf('The rbankStatus property can only contain items of int, "%s" given', is_object($orderSearchModelRbankStatusItem) ? get_class($orderSearchModelRbankStatusItem) : gettype($orderSearchModelRbankStatusItem)), __LINE__);
            }
        }
        if (is_null($rbankStatus) || (is_array($rbankStatus) && empty($rbankStatus))) {
            unset($this->rbankStatus);
        } else {
            $this->rbankStatus = $rbankStatus;
        }
        return $this;
    }
    /**
     * Add item to rbankStatus value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\OrderSearchModel
     */
    public function addToRbankStatus($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The rbankStatus property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rbankStatus[] = $item;
        return $this;
    }
    /**
     * Get reserveNumber value
     * @return string|null
     */
    public function getReserveNumber()
    {
        return $this->reserveNumber;
    }
    /**
     * Set reserveNumber value
     * @param string $reserveNumber
     * @return \StructType\OrderSearchModel
     */
    public function setReserveNumber($reserveNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reserveNumber) && !is_string($reserveNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reserveNumber)), __LINE__);
        }
        $this->reserveNumber = $reserveNumber;
        return $this;
    }
    /**
     * Get senderName value
     * @return string|null
     */
    public function getSenderName()
    {
        return $this->senderName;
    }
    /**
     * Set senderName value
     * @param string $senderName
     * @return \StructType\OrderSearchModel
     */
    public function setSenderName($senderName = null)
    {
        // validation for constraint: string
        if (!is_null($senderName) && !is_string($senderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderName)), __LINE__);
        }
        $this->senderName = $senderName;
        return $this;
    }
    /**
     * Get senderPhoneNumber value
     * @return string|null
     */
    public function getSenderPhoneNumber()
    {
        return $this->senderPhoneNumber;
    }
    /**
     * Set senderPhoneNumber value
     * @param string $senderPhoneNumber
     * @return \StructType\OrderSearchModel
     */
    public function setSenderPhoneNumber($senderPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderPhoneNumber) && !is_string($senderPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderPhoneNumber)), __LINE__);
        }
        $this->senderPhoneNumber = $senderPhoneNumber;
        return $this;
    }
    /**
     * Get settlement value
     * @return string|null
     */
    public function getSettlement()
    {
        return $this->settlement;
    }
    /**
     * Set settlement value
     * @param string $settlement
     * @return \StructType\OrderSearchModel
     */
    public function setSettlement($settlement = null)
    {
        // validation for constraint: string
        if (!is_null($settlement) && !is_string($settlement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($settlement)), __LINE__);
        }
        $this->settlement = $settlement;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\OrderSearchModel
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $status
     * @return \StructType\OrderSearchModel
     */
    public function setStatus(array $status = array())
    {
        foreach ($status as $orderSearchModelStatusItem) {
            // validation for constraint: itemType
            if (!is_string($orderSearchModelStatusItem)) {
                throw new \InvalidArgumentException(sprintf('The status property can only contain items of string, "%s" given', is_object($orderSearchModelStatusItem) ? get_class($orderSearchModelStatusItem) : gettype($orderSearchModelStatusItem)), __LINE__);
            }
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Add item to status value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OrderSearchModel
     */
    public function addToStatus($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The status property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->status[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderSearchModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
