<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemModel StructType
 * @subpackage Structs
 */
class ItemModel extends AbstractStructBase
{
    /**
     * The basketId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $basketId;
    /**
     * The deleteItemFlg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deleteItemFlg;
    /**
     * The gbuyItemModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GbuyItemModel
     */
    public $gbuyItemModel;
    /**
     * The isIncludedCashOnDeliveryPostage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isIncludedCashOnDeliveryPostage;
    /**
     * The isIncludedPostage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isIncludedPostage;
    /**
     * The isIncludedTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isIncludedTax;
    /**
     * The itemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $itemId;
    /**
     * The itemName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemName;
    /**
     * The itemNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemNumber;
    /**
     * The normalItemModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NormalItemModel
     */
    public $normalItemModel;
    /**
     * The pageURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageURL;
    /**
     * The pointRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pointRate;
    /**
     * The pointType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pointType;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $price;
    /**
     * The restoreInventoryFlag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $restoreInventoryFlag;
    /**
     * The saItemModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaItemModel
     */
    public $saItemModel;
    /**
     * The selectedChoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $selectedChoice;
    /**
     * The units
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $units;
    /**
     * Constructor method for itemModel
     * @uses ItemModel::setBasketId()
     * @uses ItemModel::setDeleteItemFlg()
     * @uses ItemModel::setGbuyItemModel()
     * @uses ItemModel::setIsIncludedCashOnDeliveryPostage()
     * @uses ItemModel::setIsIncludedPostage()
     * @uses ItemModel::setIsIncludedTax()
     * @uses ItemModel::setItemId()
     * @uses ItemModel::setItemName()
     * @uses ItemModel::setItemNumber()
     * @uses ItemModel::setNormalItemModel()
     * @uses ItemModel::setPageURL()
     * @uses ItemModel::setPointRate()
     * @uses ItemModel::setPointType()
     * @uses ItemModel::setPrice()
     * @uses ItemModel::setRestoreInventoryFlag()
     * @uses ItemModel::setSaItemModel()
     * @uses ItemModel::setSelectedChoice()
     * @uses ItemModel::setUnits()
     * @param int $basketId
     * @param bool $deleteItemFlg
     * @param \StructType\GbuyItemModel $gbuyItemModel
     * @param bool $isIncludedCashOnDeliveryPostage
     * @param bool $isIncludedPostage
     * @param bool $isIncludedTax
     * @param int $itemId
     * @param string $itemName
     * @param string $itemNumber
     * @param \StructType\NormalItemModel $normalItemModel
     * @param string $pageURL
     * @param int $pointRate
     * @param int $pointType
     * @param int $price
     * @param int $restoreInventoryFlag
     * @param \StructType\SaItemModel $saItemModel
     * @param string $selectedChoice
     * @param int $units
     */
    public function __construct($basketId = null, $deleteItemFlg = null, \StructType\GbuyItemModel $gbuyItemModel = null, $isIncludedCashOnDeliveryPostage = null, $isIncludedPostage = null, $isIncludedTax = null, $itemId = null, $itemName = null, $itemNumber = null, \StructType\NormalItemModel $normalItemModel = null, $pageURL = null, $pointRate = null, $pointType = null, $price = null, $restoreInventoryFlag = null, \StructType\SaItemModel $saItemModel = null, $selectedChoice = null, $units = null)
    {
        $this
            ->setBasketId($basketId)
            ->setDeleteItemFlg($deleteItemFlg)
            ->setGbuyItemModel($gbuyItemModel)
            ->setIsIncludedCashOnDeliveryPostage($isIncludedCashOnDeliveryPostage)
            ->setIsIncludedPostage($isIncludedPostage)
            ->setIsIncludedTax($isIncludedTax)
            ->setItemId($itemId)
            ->setItemName($itemName)
            ->setItemNumber($itemNumber)
            ->setNormalItemModel($normalItemModel)
            ->setPageURL($pageURL)
            ->setPointRate($pointRate)
            ->setPointType($pointType)
            ->setPrice($price)
            ->setRestoreInventoryFlag($restoreInventoryFlag)
            ->setSaItemModel($saItemModel)
            ->setSelectedChoice($selectedChoice)
            ->setUnits($units);
    }
    /**
     * Get basketId value
     * @return int|null
     */
    public function getBasketId()
    {
        return $this->basketId;
    }
    /**
     * Set basketId value
     * @param int $basketId
     * @return \StructType\ItemModel
     */
    public function setBasketId($basketId = null)
    {
        // validation for constraint: int
        if (!is_null($basketId) && !is_numeric($basketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($basketId)), __LINE__);
        }
        $this->basketId = $basketId;
        return $this;
    }
    /**
     * Get deleteItemFlg value
     * @return bool|null
     */
    public function getDeleteItemFlg()
    {
        return $this->deleteItemFlg;
    }
    /**
     * Set deleteItemFlg value
     * @param bool $deleteItemFlg
     * @return \StructType\ItemModel
     */
    public function setDeleteItemFlg($deleteItemFlg = null)
    {
        $this->deleteItemFlg = $deleteItemFlg;
        return $this;
    }
    /**
     * Get gbuyItemModel value
     * @return \StructType\GbuyItemModel|null
     */
    public function getGbuyItemModel()
    {
        return $this->gbuyItemModel;
    }
    /**
     * Set gbuyItemModel value
     * @param \StructType\GbuyItemModel $gbuyItemModel
     * @return \StructType\ItemModel
     */
    public function setGbuyItemModel(\StructType\GbuyItemModel $gbuyItemModel = null)
    {
        $this->gbuyItemModel = $gbuyItemModel;
        return $this;
    }
    /**
     * Get isIncludedCashOnDeliveryPostage value
     * @return bool|null
     */
    public function getIsIncludedCashOnDeliveryPostage()
    {
        return $this->isIncludedCashOnDeliveryPostage;
    }
    /**
     * Set isIncludedCashOnDeliveryPostage value
     * @param bool $isIncludedCashOnDeliveryPostage
     * @return \StructType\ItemModel
     */
    public function setIsIncludedCashOnDeliveryPostage($isIncludedCashOnDeliveryPostage = null)
    {
        $this->isIncludedCashOnDeliveryPostage = $isIncludedCashOnDeliveryPostage;
        return $this;
    }
    /**
     * Get isIncludedPostage value
     * @return bool|null
     */
    public function getIsIncludedPostage()
    {
        return $this->isIncludedPostage;
    }
    /**
     * Set isIncludedPostage value
     * @param bool $isIncludedPostage
     * @return \StructType\ItemModel
     */
    public function setIsIncludedPostage($isIncludedPostage = null)
    {
        $this->isIncludedPostage = $isIncludedPostage;
        return $this;
    }
    /**
     * Get isIncludedTax value
     * @return bool|null
     */
    public function getIsIncludedTax()
    {
        return $this->isIncludedTax;
    }
    /**
     * Set isIncludedTax value
     * @param bool $isIncludedTax
     * @return \StructType\ItemModel
     */
    public function setIsIncludedTax($isIncludedTax = null)
    {
        $this->isIncludedTax = $isIncludedTax;
        return $this;
    }
    /**
     * Get itemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param int $itemId
     * @return \StructType\ItemModel
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get itemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->itemName;
    }
    /**
     * Set itemName value
     * @param string $itemName
     * @return \StructType\ItemModel
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemName)), __LINE__);
        }
        $this->itemName = $itemName;
        return $this;
    }
    /**
     * Get itemNumber value
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->itemNumber;
    }
    /**
     * Set itemNumber value
     * @param string $itemNumber
     * @return \StructType\ItemModel
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemNumber) && !is_string($itemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemNumber)), __LINE__);
        }
        $this->itemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get normalItemModel value
     * @return \StructType\NormalItemModel|null
     */
    public function getNormalItemModel()
    {
        return $this->normalItemModel;
    }
    /**
     * Set normalItemModel value
     * @param \StructType\NormalItemModel $normalItemModel
     * @return \StructType\ItemModel
     */
    public function setNormalItemModel(\StructType\NormalItemModel $normalItemModel = null)
    {
        $this->normalItemModel = $normalItemModel;
        return $this;
    }
    /**
     * Get pageURL value
     * @return string|null
     */
    public function getPageURL()
    {
        return $this->pageURL;
    }
    /**
     * Set pageURL value
     * @param string $pageURL
     * @return \StructType\ItemModel
     */
    public function setPageURL($pageURL = null)
    {
        // validation for constraint: string
        if (!is_null($pageURL) && !is_string($pageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageURL)), __LINE__);
        }
        $this->pageURL = $pageURL;
        return $this;
    }
    /**
     * Get pointRate value
     * @return int|null
     */
    public function getPointRate()
    {
        return $this->pointRate;
    }
    /**
     * Set pointRate value
     * @param int $pointRate
     * @return \StructType\ItemModel
     */
    public function setPointRate($pointRate = null)
    {
        // validation for constraint: int
        if (!is_null($pointRate) && !is_numeric($pointRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pointRate)), __LINE__);
        }
        $this->pointRate = $pointRate;
        return $this;
    }
    /**
     * Get pointType value
     * @return int|null
     */
    public function getPointType()
    {
        return $this->pointType;
    }
    /**
     * Set pointType value
     * @param int $pointType
     * @return \StructType\ItemModel
     */
    public function setPointType($pointType = null)
    {
        // validation for constraint: int
        if (!is_null($pointType) && !is_numeric($pointType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pointType)), __LINE__);
        }
        $this->pointType = $pointType;
        return $this;
    }
    /**
     * Get price value
     * @return int|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param int $price
     * @return \StructType\ItemModel
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !is_numeric($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get restoreInventoryFlag value
     * @return int|null
     */
    public function getRestoreInventoryFlag()
    {
        return $this->restoreInventoryFlag;
    }
    /**
     * Set restoreInventoryFlag value
     * @param int $restoreInventoryFlag
     * @return \StructType\ItemModel
     */
    public function setRestoreInventoryFlag($restoreInventoryFlag = null)
    {
        // validation for constraint: int
        if (!is_null($restoreInventoryFlag) && !is_numeric($restoreInventoryFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($restoreInventoryFlag)), __LINE__);
        }
        $this->restoreInventoryFlag = $restoreInventoryFlag;
        return $this;
    }
    /**
     * Get saItemModel value
     * @return \StructType\SaItemModel|null
     */
    public function getSaItemModel()
    {
        return $this->saItemModel;
    }
    /**
     * Set saItemModel value
     * @param \StructType\SaItemModel $saItemModel
     * @return \StructType\ItemModel
     */
    public function setSaItemModel(\StructType\SaItemModel $saItemModel = null)
    {
        $this->saItemModel = $saItemModel;
        return $this;
    }
    /**
     * Get selectedChoice value
     * @return string|null
     */
    public function getSelectedChoice()
    {
        return $this->selectedChoice;
    }
    /**
     * Set selectedChoice value
     * @param string $selectedChoice
     * @return \StructType\ItemModel
     */
    public function setSelectedChoice($selectedChoice = null)
    {
        // validation for constraint: string
        if (!is_null($selectedChoice) && !is_string($selectedChoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selectedChoice)), __LINE__);
        }
        $this->selectedChoice = $selectedChoice;
        return $this;
    }
    /**
     * Get units value
     * @return int|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param int $units
     * @return \StructType\ItemModel
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !is_numeric($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($units)), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
