<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getResultResponseModel StructType
 * @subpackage Structs
 */
class GetResultResponseModel extends BaseResponseModel
{
    /**
     * The asyncResultModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AsyncResultModel[]
     */
    public $asyncResultModel;
    /**
     * Constructor method for getResultResponseModel
     * @uses GetResultResponseModel::setAsyncResultModel()
     * @param \StructType\AsyncResultModel[] $asyncResultModel
     */
    public function __construct(array $asyncResultModel = array())
    {
        $this
            ->setAsyncResultModel($asyncResultModel);
    }
    /**
     * Get asyncResultModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AsyncResultModel[]|null
     */
    public function getAsyncResultModel()
    {
        return isset($this->asyncResultModel) ? $this->asyncResultModel : null;
    }
    /**
     * Set asyncResultModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AsyncResultModel[] $asyncResultModel
     * @return \StructType\GetResultResponseModel
     */
    public function setAsyncResultModel(array $asyncResultModel = array())
    {
        foreach ($asyncResultModel as $getResultResponseModelAsyncResultModelItem) {
            // validation for constraint: itemType
            if (!$getResultResponseModelAsyncResultModelItem instanceof \StructType\AsyncResultModel) {
                throw new \InvalidArgumentException(sprintf('The asyncResultModel property can only contain items of \StructType\AsyncResultModel, "%s" given', is_object($getResultResponseModelAsyncResultModelItem) ? get_class($getResultResponseModelAsyncResultModelItem) : gettype($getResultResponseModelAsyncResultModelItem)), __LINE__);
            }
        }
        if (is_null($asyncResultModel) || (is_array($asyncResultModel) && empty($asyncResultModel))) {
            unset($this->asyncResultModel);
        } else {
            $this->asyncResultModel = $asyncResultModel;
        }
        return $this;
    }
    /**
     * Add item to asyncResultModel value
     * @throws \InvalidArgumentException
     * @param \StructType\AsyncResultModel $item
     * @return \StructType\GetResultResponseModel
     */
    public function addToAsyncResultModel(\StructType\AsyncResultModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AsyncResultModel) {
            throw new \InvalidArgumentException(sprintf('The asyncResultModel property can only contain items of \StructType\AsyncResultModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->asyncResultModel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetResultResponseModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
