<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getOrderRequestModel StructType
 * @subpackage Structs
 */
class GetOrderRequestModel extends BaseRequestModel
{
    /**
     * The isOrderNumberOnlyFlg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOrderNumberOnlyFlg;
    /**
     * The orderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $orderNumber;
    /**
     * The orderSearchModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrderSearchModel
     */
    public $orderSearchModel;
    /**
     * Constructor method for getOrderRequestModel
     * @uses GetOrderRequestModel::setIsOrderNumberOnlyFlg()
     * @uses GetOrderRequestModel::setOrderNumber()
     * @uses GetOrderRequestModel::setOrderSearchModel()
     * @param bool $isOrderNumberOnlyFlg
     * @param string[] $orderNumber
     * @param \StructType\OrderSearchModel $orderSearchModel
     */
    public function __construct($isOrderNumberOnlyFlg = null, array $orderNumber = array(), \StructType\OrderSearchModel $orderSearchModel = null)
    {
        $this
            ->setIsOrderNumberOnlyFlg($isOrderNumberOnlyFlg)
            ->setOrderNumber($orderNumber)
            ->setOrderSearchModel($orderSearchModel);
    }
    /**
     * Get isOrderNumberOnlyFlg value
     * @return bool|null
     */
    public function getIsOrderNumberOnlyFlg()
    {
        return $this->isOrderNumberOnlyFlg;
    }
    /**
     * Set isOrderNumberOnlyFlg value
     * @param bool $isOrderNumberOnlyFlg
     * @return \StructType\GetOrderRequestModel
     */
    public function setIsOrderNumberOnlyFlg($isOrderNumberOnlyFlg = null)
    {
        $this->isOrderNumberOnlyFlg = $isOrderNumberOnlyFlg;
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $orderNumber
     * @return \StructType\GetOrderRequestModel
     */
    public function setOrderNumber(array $orderNumber = array())
    {
        foreach ($orderNumber as $getOrderRequestModelOrderNumberItem) {
            // validation for constraint: itemType
            if (!is_string($getOrderRequestModelOrderNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($getOrderRequestModelOrderNumberItem) ? get_class($getOrderRequestModelOrderNumberItem) : gettype($getOrderRequestModelOrderNumberItem)), __LINE__);
            }
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Add item to orderNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetOrderRequestModel
     */
    public function addToOrderNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The orderNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderNumber[] = $item;
        return $this;
    }
    /**
     * Get orderSearchModel value
     * @return \StructType\OrderSearchModel|null
     */
    public function getOrderSearchModel()
    {
        return $this->orderSearchModel;
    }
    /**
     * Set orderSearchModel value
     * @param \StructType\OrderSearchModel $orderSearchModel
     * @return \StructType\GetOrderRequestModel
     */
    public function setOrderSearchModel(\StructType\OrderSearchModel $orderSearchModel = null)
    {
        $this->orderSearchModel = $orderSearchModel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOrderRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
