<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for doEnclosureRequestModel StructType
 * @subpackage Structs
 */
class DoEnclosureRequestModel extends BaseRequestModel
{
    /**
     * The nominateEnclosureModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NominateEnclosureModel[]
     */
    public $nominateEnclosureModel;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for doEnclosureRequestModel
     * @uses DoEnclosureRequestModel::setNominateEnclosureModel()
     * @uses DoEnclosureRequestModel::setRequestId()
     * @param \StructType\NominateEnclosureModel[] $nominateEnclosureModel
     * @param int $requestId
     */
    public function __construct(array $nominateEnclosureModel = array(), $requestId = null)
    {
        $this
            ->setNominateEnclosureModel($nominateEnclosureModel)
            ->setRequestId($requestId);
    }
    /**
     * Get nominateEnclosureModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NominateEnclosureModel[]|null
     */
    public function getNominateEnclosureModel()
    {
        return isset($this->nominateEnclosureModel) ? $this->nominateEnclosureModel : null;
    }
    /**
     * Set nominateEnclosureModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NominateEnclosureModel[] $nominateEnclosureModel
     * @return \StructType\DoEnclosureRequestModel
     */
    public function setNominateEnclosureModel(array $nominateEnclosureModel = array())
    {
        foreach ($nominateEnclosureModel as $doEnclosureRequestModelNominateEnclosureModelItem) {
            // validation for constraint: itemType
            if (!$doEnclosureRequestModelNominateEnclosureModelItem instanceof \StructType\NominateEnclosureModel) {
                throw new \InvalidArgumentException(sprintf('The nominateEnclosureModel property can only contain items of \StructType\NominateEnclosureModel, "%s" given', is_object($doEnclosureRequestModelNominateEnclosureModelItem) ? get_class($doEnclosureRequestModelNominateEnclosureModelItem) : gettype($doEnclosureRequestModelNominateEnclosureModelItem)), __LINE__);
            }
        }
        if (is_null($nominateEnclosureModel) || (is_array($nominateEnclosureModel) && empty($nominateEnclosureModel))) {
            unset($this->nominateEnclosureModel);
        } else {
            $this->nominateEnclosureModel = $nominateEnclosureModel;
        }
        return $this;
    }
    /**
     * Add item to nominateEnclosureModel value
     * @throws \InvalidArgumentException
     * @param \StructType\NominateEnclosureModel $item
     * @return \StructType\DoEnclosureRequestModel
     */
    public function addToNominateEnclosureModel(\StructType\NominateEnclosureModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NominateEnclosureModel) {
            throw new \InvalidArgumentException(sprintf('The nominateEnclosureModel property can only contain items of \StructType\NominateEnclosureModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->nominateEnclosureModel[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\DoEnclosureRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoEnclosureRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
