<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for changeStatusRequestModel StructType
 * @subpackage Structs
 */
class ChangeStatusRequestModel extends BaseRequestModel
{
    /**
     * The orderStatusModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderStatusModel[]
     */
    public $orderStatusModel;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for changeStatusRequestModel
     * @uses ChangeStatusRequestModel::setOrderStatusModel()
     * @uses ChangeStatusRequestModel::setRequestId()
     * @param \StructType\OrderStatusModel[] $orderStatusModel
     * @param int $requestId
     */
    public function __construct(array $orderStatusModel = array(), $requestId = null)
    {
        $this
            ->setOrderStatusModel($orderStatusModel)
            ->setRequestId($requestId);
    }
    /**
     * Get orderStatusModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderStatusModel[]|null
     */
    public function getOrderStatusModel()
    {
        return isset($this->orderStatusModel) ? $this->orderStatusModel : null;
    }
    /**
     * Set orderStatusModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStatusModel[] $orderStatusModel
     * @return \StructType\ChangeStatusRequestModel
     */
    public function setOrderStatusModel(array $orderStatusModel = array())
    {
        foreach ($orderStatusModel as $changeStatusRequestModelOrderStatusModelItem) {
            // validation for constraint: itemType
            if (!$changeStatusRequestModelOrderStatusModelItem instanceof \StructType\OrderStatusModel) {
                throw new \InvalidArgumentException(sprintf('The orderStatusModel property can only contain items of \StructType\OrderStatusModel, "%s" given', is_object($changeStatusRequestModelOrderStatusModelItem) ? get_class($changeStatusRequestModelOrderStatusModelItem) : gettype($changeStatusRequestModelOrderStatusModelItem)), __LINE__);
            }
        }
        if (is_null($orderStatusModel) || (is_array($orderStatusModel) && empty($orderStatusModel))) {
            unset($this->orderStatusModel);
        } else {
            $this->orderStatusModel = $orderStatusModel;
        }
        return $this;
    }
    /**
     * Add item to orderStatusModel value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStatusModel $item
     * @return \StructType\ChangeStatusRequestModel
     */
    public function addToOrderStatusModel(\StructType\OrderStatusModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderStatusModel) {
            throw new \InvalidArgumentException(sprintf('The orderStatusModel property can only contain items of \StructType\OrderStatusModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderStatusModel[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\ChangeStatusRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeStatusRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
