<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for changeEnclosureParentRequestModel StructType
 * @subpackage Structs
 */
class ChangeEnclosureParentRequestModel extends BaseRequestModel
{
    /**
     * The changeEnclosureParentModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChangeEnclosureParentModel[]
     */
    public $changeEnclosureParentModel;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for changeEnclosureParentRequestModel
     * @uses ChangeEnclosureParentRequestModel::setChangeEnclosureParentModel()
     * @uses ChangeEnclosureParentRequestModel::setRequestId()
     * @param \StructType\ChangeEnclosureParentModel[] $changeEnclosureParentModel
     * @param int $requestId
     */
    public function __construct(array $changeEnclosureParentModel = array(), $requestId = null)
    {
        $this
            ->setChangeEnclosureParentModel($changeEnclosureParentModel)
            ->setRequestId($requestId);
    }
    /**
     * Get changeEnclosureParentModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChangeEnclosureParentModel[]|null
     */
    public function getChangeEnclosureParentModel()
    {
        return isset($this->changeEnclosureParentModel) ? $this->changeEnclosureParentModel : null;
    }
    /**
     * Set changeEnclosureParentModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeEnclosureParentModel[] $changeEnclosureParentModel
     * @return \StructType\ChangeEnclosureParentRequestModel
     */
    public function setChangeEnclosureParentModel(array $changeEnclosureParentModel = array())
    {
        foreach ($changeEnclosureParentModel as $changeEnclosureParentRequestModelChangeEnclosureParentModelItem) {
            // validation for constraint: itemType
            if (!$changeEnclosureParentRequestModelChangeEnclosureParentModelItem instanceof \StructType\ChangeEnclosureParentModel) {
                throw new \InvalidArgumentException(sprintf('The changeEnclosureParentModel property can only contain items of \StructType\ChangeEnclosureParentModel, "%s" given', is_object($changeEnclosureParentRequestModelChangeEnclosureParentModelItem) ? get_class($changeEnclosureParentRequestModelChangeEnclosureParentModelItem) : gettype($changeEnclosureParentRequestModelChangeEnclosureParentModelItem)), __LINE__);
            }
        }
        if (is_null($changeEnclosureParentModel) || (is_array($changeEnclosureParentModel) && empty($changeEnclosureParentModel))) {
            unset($this->changeEnclosureParentModel);
        } else {
            $this->changeEnclosureParentModel = $changeEnclosureParentModel;
        }
        return $this;
    }
    /**
     * Add item to changeEnclosureParentModel value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeEnclosureParentModel $item
     * @return \StructType\ChangeEnclosureParentRequestModel
     */
    public function addToChangeEnclosureParentModel(\StructType\ChangeEnclosureParentModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeEnclosureParentModel) {
            throw new \InvalidArgumentException(sprintf('The changeEnclosureParentModel property can only contain items of \StructType\ChangeEnclosureParentModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->changeEnclosureParentModel[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\ChangeEnclosureParentRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeEnclosureParentRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
