<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardSearchModel StructType
 * @subpackage Structs
 */
class CardSearchModel extends AbstractStructBase
{
    /**
     * The cardName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardName;
    /**
     * The cardOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardOwner;
    /**
     * The cardStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $cardStatus;
    /**
     * The payType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $payType;
    /**
     * Constructor method for cardSearchModel
     * @uses CardSearchModel::setCardName()
     * @uses CardSearchModel::setCardOwner()
     * @uses CardSearchModel::setCardStatus()
     * @uses CardSearchModel::setPayType()
     * @param string $cardName
     * @param string $cardOwner
     * @param int[] $cardStatus
     * @param int[] $payType
     */
    public function __construct($cardName = null, $cardOwner = null, array $cardStatus = array(), array $payType = array())
    {
        $this
            ->setCardName($cardName)
            ->setCardOwner($cardOwner)
            ->setCardStatus($cardStatus)
            ->setPayType($payType);
    }
    /**
     * Get cardName value
     * @return string|null
     */
    public function getCardName()
    {
        return $this->cardName;
    }
    /**
     * Set cardName value
     * @param string $cardName
     * @return \StructType\CardSearchModel
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardName)), __LINE__);
        }
        $this->cardName = $cardName;
        return $this;
    }
    /**
     * Get cardOwner value
     * @return string|null
     */
    public function getCardOwner()
    {
        return $this->cardOwner;
    }
    /**
     * Set cardOwner value
     * @param string $cardOwner
     * @return \StructType\CardSearchModel
     */
    public function setCardOwner($cardOwner = null)
    {
        // validation for constraint: string
        if (!is_null($cardOwner) && !is_string($cardOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardOwner)), __LINE__);
        }
        $this->cardOwner = $cardOwner;
        return $this;
    }
    /**
     * Get cardStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getCardStatus()
    {
        return isset($this->cardStatus) ? $this->cardStatus : null;
    }
    /**
     * Set cardStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $cardStatus
     * @return \StructType\CardSearchModel
     */
    public function setCardStatus(array $cardStatus = array())
    {
        foreach ($cardStatus as $cardSearchModelCardStatusItem) {
            // validation for constraint: itemType
            if (!is_numeric($cardSearchModelCardStatusItem)) {
                throw new \InvalidArgumentException(sprintf('The cardStatus property can only contain items of int, "%s" given', is_object($cardSearchModelCardStatusItem) ? get_class($cardSearchModelCardStatusItem) : gettype($cardSearchModelCardStatusItem)), __LINE__);
            }
        }
        if (is_null($cardStatus) || (is_array($cardStatus) && empty($cardStatus))) {
            unset($this->cardStatus);
        } else {
            $this->cardStatus = $cardStatus;
        }
        return $this;
    }
    /**
     * Add item to cardStatus value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\CardSearchModel
     */
    public function addToCardStatus($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The cardStatus property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cardStatus[] = $item;
        return $this;
    }
    /**
     * Get payType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getPayType()
    {
        return isset($this->payType) ? $this->payType : null;
    }
    /**
     * Set payType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $payType
     * @return \StructType\CardSearchModel
     */
    public function setPayType(array $payType = array())
    {
        foreach ($payType as $cardSearchModelPayTypeItem) {
            // validation for constraint: itemType
            if (!is_numeric($cardSearchModelPayTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The payType property can only contain items of int, "%s" given', is_object($cardSearchModelPayTypeItem) ? get_class($cardSearchModelPayTypeItem) : gettype($cardSearchModelPayTypeItem)), __LINE__);
            }
        }
        if (is_null($payType) || (is_array($payType) && empty($payType))) {
            unset($this->payType);
        } else {
            $this->payType = $payType;
        }
        return $this;
    }
    /**
     * Add item to payType value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\CardSearchModel
     */
    public function addToPayType($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The payType property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardSearchModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
