<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardModel StructType
 * @subpackage Structs
 */
class CardModel extends AbstractStructBase
{
    /**
     * The brandName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brandName;
    /**
     * The cardNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cardNo;
    /**
     * The expYM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expYM;
    /**
     * The installmentDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $installmentDesc;
    /**
     * The ownerName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ownerName;
    /**
     * The payType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $payType;
    /**
     * Constructor method for cardModel
     * @uses CardModel::setBrandName()
     * @uses CardModel::setCardNo()
     * @uses CardModel::setExpYM()
     * @uses CardModel::setInstallmentDesc()
     * @uses CardModel::setOwnerName()
     * @uses CardModel::setPayType()
     * @param string $brandName
     * @param string $cardNo
     * @param string $expYM
     * @param string $installmentDesc
     * @param string $ownerName
     * @param int $payType
     */
    public function __construct($brandName = null, $cardNo = null, $expYM = null, $installmentDesc = null, $ownerName = null, $payType = null)
    {
        $this
            ->setBrandName($brandName)
            ->setCardNo($cardNo)
            ->setExpYM($expYM)
            ->setInstallmentDesc($installmentDesc)
            ->setOwnerName($ownerName)
            ->setPayType($payType);
    }
    /**
     * Get brandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->brandName;
    }
    /**
     * Set brandName value
     * @param string $brandName
     * @return \StructType\CardModel
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->brandName = $brandName;
        return $this;
    }
    /**
     * Get cardNo value
     * @return string|null
     */
    public function getCardNo()
    {
        return $this->cardNo;
    }
    /**
     * Set cardNo value
     * @param string $cardNo
     * @return \StructType\CardModel
     */
    public function setCardNo($cardNo = null)
    {
        // validation for constraint: string
        if (!is_null($cardNo) && !is_string($cardNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNo)), __LINE__);
        }
        $this->cardNo = $cardNo;
        return $this;
    }
    /**
     * Get expYM value
     * @return string|null
     */
    public function getExpYM()
    {
        return $this->expYM;
    }
    /**
     * Set expYM value
     * @param string $expYM
     * @return \StructType\CardModel
     */
    public function setExpYM($expYM = null)
    {
        // validation for constraint: string
        if (!is_null($expYM) && !is_string($expYM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expYM)), __LINE__);
        }
        $this->expYM = $expYM;
        return $this;
    }
    /**
     * Get installmentDesc value
     * @return string|null
     */
    public function getInstallmentDesc()
    {
        return $this->installmentDesc;
    }
    /**
     * Set installmentDesc value
     * @param string $installmentDesc
     * @return \StructType\CardModel
     */
    public function setInstallmentDesc($installmentDesc = null)
    {
        // validation for constraint: string
        if (!is_null($installmentDesc) && !is_string($installmentDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installmentDesc)), __LINE__);
        }
        $this->installmentDesc = $installmentDesc;
        return $this;
    }
    /**
     * Get ownerName value
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->ownerName;
    }
    /**
     * Set ownerName value
     * @param string $ownerName
     * @return \StructType\CardModel
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerName)), __LINE__);
        }
        $this->ownerName = $ownerName;
        return $this;
    }
    /**
     * Get payType value
     * @return int|null
     */
    public function getPayType()
    {
        return $this->payType;
    }
    /**
     * Set payType value
     * @param int $payType
     * @return \StructType\CardModel
     */
    public function setPayType($payType = null)
    {
        // validation for constraint: int
        if (!is_null($payType) && !is_numeric($payType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payType)), __LINE__);
        }
        $this->payType = $payType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
