<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelOrderRequestModel StructType
 * @subpackage Structs
 */
class CancelOrderRequestModel extends BaseRequestModel
{
    /**
     * The cancelModelList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CancelModel[]
     */
    public $cancelModelList;
    /**
     * The requestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $requestId;
    /**
     * Constructor method for cancelOrderRequestModel
     * @uses CancelOrderRequestModel::setCancelModelList()
     * @uses CancelOrderRequestModel::setRequestId()
     * @param \StructType\CancelModel[] $cancelModelList
     * @param int $requestId
     */
    public function __construct(array $cancelModelList = array(), $requestId = null)
    {
        $this
            ->setCancelModelList($cancelModelList)
            ->setRequestId($requestId);
    }
    /**
     * Get cancelModelList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CancelModel[]|null
     */
    public function getCancelModelList()
    {
        return isset($this->cancelModelList) ? $this->cancelModelList : null;
    }
    /**
     * Set cancelModelList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CancelModel[] $cancelModelList
     * @return \StructType\CancelOrderRequestModel
     */
    public function setCancelModelList(array $cancelModelList = array())
    {
        foreach ($cancelModelList as $cancelOrderRequestModelCancelModelListItem) {
            // validation for constraint: itemType
            if (!$cancelOrderRequestModelCancelModelListItem instanceof \StructType\CancelModel) {
                throw new \InvalidArgumentException(sprintf('The cancelModelList property can only contain items of \StructType\CancelModel, "%s" given', is_object($cancelOrderRequestModelCancelModelListItem) ? get_class($cancelOrderRequestModelCancelModelListItem) : gettype($cancelOrderRequestModelCancelModelListItem)), __LINE__);
            }
        }
        if (is_null($cancelModelList) || (is_array($cancelModelList) && empty($cancelModelList))) {
            unset($this->cancelModelList);
        } else {
            $this->cancelModelList = $cancelModelList;
        }
        return $this;
    }
    /**
     * Add item to cancelModelList value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelModel $item
     * @return \StructType\CancelOrderRequestModel
     */
    public function addToCancelModelList(\StructType\CancelModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelModel) {
            throw new \InvalidArgumentException(sprintf('The cancelModelList property can only contain items of \StructType\CancelModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cancelModelList[] = $item;
        return $this;
    }
    /**
     * Get requestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param int $requestId
     * @return \StructType\CancelOrderRequestModel
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !is_numeric($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelOrderRequestModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
